<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Model;

use \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory;
use Magento\Eav\Api\AttributeManagementInterface;
use \Magento\Eav\Model\Config;

/**
 * TODO: Se un giorno riuscirò a capire come Magento fa per calcolare (più che altro quale metodo offre) quali sono gli attributi utilizzati per creare configurabili questa si potrà eliminare
 *
 * Class Attribute
 * @package Drop\Import\Model
 */
class Attribute
{

    /**
     * @var CollectionFactory $collectionFactory
     */
    private $collectionFactory;

    /**
     * @var AttributeManagementInterface $attributeManagement
     */
    private $attributeManagement;

    /**
     * @var Config $config
     */
    private $config;

    public function __construct(
        CollectionFactory $collectionFactory,
        AttributeManagementInterface $attributeManagement,
        Config $config
    )
    {
        $this->collectionFactory = $collectionFactory;
        $this->attributeManagement = $attributeManagement;
        $this->config = $config;
    }

    /**
     * Get all user defined attribute to set. Defined by magento will be setted manually
     * @param $attributeSetName
     * @return array
     */
    public function getUserDefinedAttributeByAttributeSet($attributeSetName)
    {
        $attributeSetId = $this->_getAttributeSetIdByName($attributeSetName);
        $attributes = $this->_getAttributesOfAttributeSet($attributeSetId);

        $userDefinedAttributes = [];
        foreach ($attributes as $attribute) {
            if ($attribute->getIsUserDefined()) {
                $userDefinedAttributes[] = $attribute->getAttributeCode();
            }
        }

        return $userDefinedAttributes;
    }

    /**
     * Get attribute Set Id By Name
     * @param type $attributeSetName
     * @return int
     */
    public function _getAttributeSetIdByName($attributeSetName)
    {
        $attributeSetCollection = $this->collectionFactory->create()
            ->addFieldToSelect('*')
            ->addFieldToFilter('attribute_set_name', $attributeSetName)
            ->addFieldToFilter('entity_type_id', 4)
            ->getFirstItem()
            ->toArray();
        return (int) $attributeSetCollection['attribute_set_id'];
    }

    /**
     * $this->_getAttributeSet(9);
     * Load attribute set by Id
     * @param type $attributeSetId
     * @throws Exception
     */
//    private function _getAttributeSet($attributeSetId) {
//        $attributeSet = $this->objectManager->create(\Magento\Eav\Model\Entity\Attribute\Set::class)->load($attributeSetId);
//        if (!$attributeSet->getId()) {
//            throw new Exception('Cannot find attributeSetId ' . $attributeSetId);
//        }
//        return $attributeSet;
//    }

    /**
     * Get all attributes of an attribute set by Id
     * @param type $attributeSetId
     */
    public function _getAttributesOfAttributeSet($attributeSetId)
    {
        return $this->attributeManagement->getAttributes(\Magento\Catalog\Api\Data\ProductAttributeInterface::ENTITY_TYPE_CODE, $attributeSetId);
    }

    /**
     * Load attribute via Eav\Model\Config (only way to get is_global attribute)
     * If is global, is dropdown and is applicable to configurable or all it can be a super attribute
     * @param type $attributeCode
     * @return array getAllOptions();
     */
    public function _getIsSuperAttribute($attributeCode)
    {
        $attribute = $this->config->getAttribute('catalog_product', $attributeCode);

        if ($attribute->isScopeGlobal() &&
            (($attribute->getBackendType() == 'int') && ($attribute->getFrontendInput() == 'select')) &&
            ($attribute->getIsUserDefined() == 1) && ($attribute->getNote() == 'super_attribute') &&
            (in_array('configurable', $attribute->getApplyTo()) || empty($attribute->getApplyTo()))
        ) {
            return $attribute->getSource()->getAllOptions();
        }
        return false;
    }

    public function getOptionText($attributeCode, $value) {
        $attribute = $this->config->getAttribute('catalog_product', $attributeCode);
        if($attribute->getFrontendInput() == 'select') {
            return $attribute->getSource()->getOptionText($value);
        }
        return false;
    }

    /**
     * Logic function
     * @param type $attributeSetName
     * @return array|type
     */
    public function getSuperAttributeOptions($attributeSetName)
    {
        $attributeSetId = $this->_getAttributeSetIdByName($attributeSetName);
        $attributes = $this->_getAttributesOfAttributeSet($attributeSetId);

        $superAttributes = [];
        foreach ($attributes as $attribute) {
            if ($superAttributesOptions = $this->_getIsSuperAttribute($attribute->getAttributeCode())) {
                $superAttributes[$attribute->getAttributeCode()] = $superAttributesOptions;
            }
        }

        return $superAttributes;

//        //Get attribute that has the same name of attribute set
//        return [$attributeSetName => $this->_getIsSuperAttribute($attributeSetName)];
    }

    /**
     * Logic function
     * @param type $attributeSetName
     * @return array|type
     */
    public function getSwatchAttributeOptions($attributeSetName)
    {
        $attributeSetId = $this->_getAttributeSetIdByName($attributeSetName);
        $attributes = $this->_getAttributesOfAttributeSet($attributeSetId);
        $swatchAttributes = [];
        foreach ($attributes as $attribute) {
            if ($swatchAttributesOptions = $this->_getIsSwatchAttribute($attribute->getAttributeCode())) {
                $swatchAttributes[$attribute->getAttributeCode()] = $swatchAttributesOptions;
            }
        }
        return $swatchAttributes;
    }

    public function _getIsSwatchAttribute($attributeCode)
    {
        $attribute = $this->config->getAttribute('catalog_product', $attributeCode);

        if ($attribute->isScopeGlobal() &&
            (($attribute->getBackendType() == 'int') && ($attribute->getFrontendInput() == 'select')) &&
            ($attribute->getIsUserDefined() == 1) &&
            (in_array('configurable', $attribute->getApplyTo()) || empty($attribute->getApplyTo()))
        ) {
            $additionalData = json_decode($attribute->getAdditionalData());
            if(!empty($additionalData) && !empty($additionalData->swatch_input_type)) {
                return $attribute->getSource()->getAllOptions();
            }
        }
        return false;
    }

}
