<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Helper;

class UrlRewrite extends Data implements CommandInterface {

    const XML_PATH_URLREWRITE_IMPORT_METHOD = 'dropimport/urlrewrite_configuration/import_method';
    const XML_PATH_URLREWRITE_IMPORT_SPREADSHEET_ID = 'dropimport/urlrewrite_configuration/spreadsheet_id';
    const XML_PATH_URLREWRITE_IMPORT_SHEET_TITLE = 'dropimport/urlrewrite_configuration/import_sheet_title';
    const XML_PATH_URLREWRITE_IMPORT_PATH_URL = 'dropimport/urlrewrite_configuration/import_path_url';

    /**
     * Get Import Method
     *
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_URLREWRITE_IMPORT_METHOD);
    }

    /**
     * Get Spreadsheet Id
     *
     * @return int
     */
    public function getSpreadsheetId()
    {
        return $this->getScopeConfig(self::XML_PATH_URLREWRITE_IMPORT_SPREADSHEET_ID);
    }

    /**
     * Get Sheet Title
     *
     * @return int
     */
    public function getSheetTitle()
    {
        return $this->getScopeConfig(self::XML_PATH_URLREWRITE_IMPORT_SHEET_TITLE);
    }

    /**
     * Get Import Path or Url
     *
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_URLREWRITE_IMPORT_PATH_URL);
    }

    /**
     * Return fake entity name for log purpose
     * @return string
     */
    public function getScriptNameForEmailLog() {
        return 'UrlRewrite';
    }

    /**
     * @param string $url
     * @return string
     */
    public function getCleanedRequestPath(string $url) {
        return $this->removeFirstCharacterIfSlash($this->getCleanedUrl($url));
    }

    /**
     * @param string $url
     * @return string
     */
    public function getCleanedTargetPath(string $url) {
        return $this->removeFirstCharacterIfSlash($this->removeLanguageFromUrl($this->getCleanedUrl($url)));
    }

    /**
     * @param string $url
     * @return string
     */
    public function getCleanedUrl(string $url) {
        return parse_url($url, PHP_URL_PATH);
    }

    /**
     * @param string $url
     * @return string
     */
    public function removeLanguageFromUrl(string $url) {
        foreach($this->getAllStores() as $store) {
            if(strpos($url, '/' . $store->getCode() . '/') !== false) {
                return str_replace('/' . $store->getCode(), '', $url);
            }
        }
        return $url;
    }

    /**
     * @param string $url
     * @return string
     */
    public function removeFirstCharacterIfSlash(string $url) {
        return ltrim($url, '/');
    }
       
}
