<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Helper;

class Subscriber extends Data implements CommandInterface {

    const XML_PATH_CONFIRMATION_FLAG = 'newsletter/subscription/confirm';

    const XML_PATH_SUBSCRIBER_IMPORT_METHOD = 'dropimport/subscriber_configuration/import_method';
    const XML_PATH_SUBSCRIBER_IMPORT_SPREADSHEET_ID = 'dropimport/subscriber_configuration/spreadsheet_id';
    const XML_PATH_SUBSCRIBER_IMPORT_SHEET_TITLE = 'dropimport/subscriber_configuration/import_sheet_title';
    const XML_PATH_SUBSCRIBER_IMPORT_PATH_URL = 'dropimport/subscriber_configuration/import_path_url';

    /**
     * Get Import Method
     *
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_SUBSCRIBER_IMPORT_METHOD);
    }

    /**
     * Get Spreadsheet Id
     *
     * @return int
     */
    public function getSpreadsheetId()
    {
        return $this->getScopeConfig(self::XML_PATH_SUBSCRIBER_IMPORT_SPREADSHEET_ID);
    }

    /**
     * Get Sheet Title
     *
     * @return int
     */
    public function getSheetTitle()
    {
        return $this->getScopeConfig(self::XML_PATH_SUBSCRIBER_IMPORT_SHEET_TITLE);
    }

    /**
     * Get Import Path or Url
     *
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_SUBSCRIBER_IMPORT_PATH_URL);
    }

    /**
     * Return fake entity name for log purpose
     * @return string
     */
    public function getScriptNameForEmailLog() {
        return 'Subscriber';
    }

    /**
     *
     */
    public function getSubscriberConfirmation() {
        $this->getScopeConfig(self::XML_PATH_CONFIRMATION_FLAG);
    }

    /**
     * @param $value
     */
    public function setSubscriberConfirmation($value) {
        $this->setScopeConfig(self::XML_PATH_CONFIRMATION_FLAG, $value);
    }

}
