<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Helper;

class AttributeSet extends Data implements EntitiesInterface {

    const ENTITY_CODE = 'catalog_attributeset';
    const XML_PATH_ATTRIBUTE_SET_BEHAVIOR            = 'dropimport/attributeset_configuration/behavior';
    const XML_PATH_ATTRIBUTE_IMPORT_CRON           = 'dropimport/attributeset_configuration/import_cron';

    const XML_PATH_ATTRIBUTE_SET_IMPORT_METHOD = 'dropimport/attributeset_configuration/import_method';
    const XML_PATH_ATTRIBUTE_SET_IMPORT_SPREADSHEET_ID = 'dropimport/attributeset_configuration/spreadsheet_id';
    const XML_PATH_ATTRIBUTE_SET_IMPORT_SHEET_TITLE = 'dropimport/attributeset_configuration/import_sheet_title';
    const XML_PATH_ATTRIBUTE_SET_IMPORT_PATH_URL = 'dropimport/attributeset_configuration/import_path_url';
    /**
     * @var \Magento\Catalog\Model\Product\AttributeSet\OptionsFactory
     */
    private $optionsFactory;

    /**
     * AttributeSet constructor.
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Config\Storage\WriterInterface $configWriter
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Customer\Model\ResourceModel\Group\CollectionFactory $customerGroupFactory
     * @param \Magento\Directory\Model\CountryFactory $countryFactory
     * @param \Magento\Catalog\Model\Product\AttributeSet\OptionsFactory $optionsFactory
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Config\Storage\WriterInterface $configWriter,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Model\ResourceModel\Group\CollectionFactory $customerGroupFactory,
        \Magento\Directory\Model\CountryFactory $countryFactory,
        \Magento\Catalog\Model\Product\AttributeSet\OptionsFactory $optionsFactory
    )
    {
        $this->optionsFactory = $optionsFactory;
        parent::__construct($context, $scopeConfig, $configWriter, $storeManager, $customerGroupFactory, $countryFactory);
    }

    /**
     * Get Behavior
     *
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_SET_BEHAVIOR);
    }

    /**
     * Get Import Cron
     *
     * @return int
     */
    public function getImportCron()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_CRON);
    }

    /**
     * Get Import Method
     *
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_SET_IMPORT_METHOD);
    }

    /**
     * Get Spreadsheet Id
     *
     * @return int
     */
    public function getSpreadsheetId()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_SET_IMPORT_SPREADSHEET_ID);
    }

    /**
     * Get Sheet Title
     *
     * @return int
     */
    public function getSheetTitle()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_SET_IMPORT_SHEET_TITLE);
    }

    /**
     * Get Import Path or Url
     *
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_SET_IMPORT_PATH_URL);
    }

    /**
     * Get Entity Code
     * 
     * @return string
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }

    /**
     * @param string $attributeSetName
     */
    public function getAttributeSetExistByName(string $attributeSetName) {
        /** @var \Magento\Catalog\Model\Product\AttributeSet\Options $attributeSetOptions */
        $attributeSetOptions = $this->optionsFactory->create();
        foreach($attributeSetOptions->toOptionArray() as $attributeSet) {
            if($attributeSet['label'] == $attributeSetName) {
                return true;
            }
        }
        return false;
    }
       
}
