<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Helper;

class Attribute extends Data implements EntitiesInterface {

    const ENTITY_CODE = 'catalog_attribute';
    const XML_PATH_ATTRIBUTE_BEHAVIOR            = 'dropimport/attribute_configuration/behavior';
    const XML_PATH_ATTRIBUTE_IMPORT_CRON           = 'dropimport/attribute_configuration/import_cron';

    const XML_PATH_ATTRIBUTE_IMPORT_METHOD = 'dropimport/attribute_configuration/import_method';
    const XML_PATH_ATTRIBUTE_IMPORT_SPREADSHEET_ID = 'dropimport/attribute_configuration/spreadsheet_id';
    const XML_PATH_ATTRIBUTE_IMPORT_SHEET_TITLE = 'dropimport/attribute_configuration/import_sheet_title';
    const XML_PATH_ATTRIBUTE_IMPORT_PATH_URL = 'dropimport/attribute_configuration/import_path_url';

    /**
     * Get Behavior
     *
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_BEHAVIOR);
    }

    /**
     * Get Import Cron
     *
     * @return int
     */
    public function getImportCron()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_CRON);
    }

    /**
     * Get Import Method
     *
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_METHOD);
    }

    /**
     * Get Spreadsheet Id
     *
     * @return int
     */
    public function getSpreadsheetId()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_SPREADSHEET_ID);
    }

    /**
     * Get Sheet Title
     *
     * @return int
     */
    public function getSheetTitle()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_SHEET_TITLE);
    }

    /**
     * Get Import Path or Url
     *
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_ATTRIBUTE_IMPORT_PATH_URL);
    }

    /**
     * Get Entity Code
     * 
     * @return string
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }    
       
}
