<?php

namespace Drop\Import\Cron\Import;

class Categories
{
    /**
     * @var \Drop\Import\Helper\Category
     */
    private $helper;
    /**
     * @var \Drop\Import\Console\Command\Import\Entities\Categories
     */
    private $importer;
    /**
     * @var \Drop\Import\Logger\Logger
     */
    private $logger;

    /**
     * Categories constructor.
     * @param \Drop\Import\Helper\Category $helper
     * @param \Drop\Import\Console\Command\Import\Entities\Categories $importer
     * @param \Drop\Import\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Import\Helper\Category $helper,
        \Drop\Import\Console\Command\Import\Entities\Categories $importer,
        \Drop\Import\Logger\Logger $logger
    )
    {
        $this->helper = $helper;
        $this->importer = $importer;
        $this->logger = $logger;
    }

    public function execute()
    {
        if(!$this->helper->getImportCron()) {
            return $this;
        }

        try {
            $this->importer->import();
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
        }

    }
}
