<?php

namespace Drop\Import\Cron\Import;


class AttributesSet
{
    /**
     * @var \Drop\Import\Helper\AttributeSet
     */
    private $helper;
    /**
     * @var \Drop\Import\Console\Command\Import\Entities\AttributesSet
     */
    private $importer;
    /**
     * @var \Drop\Import\Logger\Logger
     */
    private $logger;

    /**
     * AttributesSet constructor.
     * @param \Drop\Import\Helper\AttributeSet $helper
     * @param \Drop\Import\Console\Command\Import\Entities\AttributesSet $importer
     * @param \Drop\Import\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Import\Helper\AttributeSet $helper,
        \Drop\Import\Console\Command\Import\Entities\AttributesSet $importer,
        \Drop\Import\Logger\Logger $logger
    )
    {

        $this->helper = $helper;
        $this->importer = $importer;
        $this->logger = $logger;
    }

    public function execute()
    {
        if(!$this->helper->getImportCron()) {
            return $this;
        }

        try {
            $this->importer->import();
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
        }

    }
}
