<?php

namespace Drop\Import\Cron\Import;


class Attributes
{
    /**
     * @var \Drop\Import\Helper\Attribute
     */
    private $helper;
    /**
     * @var \Drop\Import\Console\Command\Import\Entities\Attributes
     */
    private $importer;
    /**
     * @var \Drop\Import\Logger\Logger
     */
    private $logger;

    /**
     * Products constructor.
     * @param \Drop\Import\Helper\Attribute $helper
     * @param \Drop\Import\Console\Command\Import\Entities\Attributes $importer
     * @param \Drop\Import\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Import\Helper\Attribute $helper,
        \Drop\Import\Console\Command\Import\Entities\Attributes $importer,
        \Drop\Import\Logger\Logger $logger
    )
    {

        $this->helper = $helper;
        $this->importer = $importer;
        $this->logger = $logger;
    }

    public function execute()
    {
        if(!$this->helper->getImportCron()) {
            return $this;
        }

        try {
            $this->importer->import();
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
        }

    }
}
