<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;
use \Drop\Import\Console\Command\Import\Entities\Products\AbstractProducts;

class Stock extends AbstractProducts
{
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product
     */
    private $formatter;

    /**
     * Stock constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Checkers\Entities\Product $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Product $formatter
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Checkers\Entities\Product $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Product $formatter
    ){
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }
    

    protected function configure()
    {
        $this->setName('drop:update:stock')
            ->setDescription('Update Products Stock');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array|void
     */
    protected function getEntities(array $inputData)
    {
        die(__METHOD__);
    }

    public function beforeImport()
    {
        $this->helper
            ->setBehavior(\Drop\Import\Model\Config\Source\Behavior::BEHAVIOR_UPDATE)
            ->setSheetTitle(\Drop\Import\Helper\Product::SHEET_TITLE_STOCK);
        return parent::beforeImport();
    }

}
