<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;
use \Drop\Import\Console\Command\Import\Entities\Products\AbstractProducts;
use \Drop\Import\Model\Formatter\Product;

class Related extends AbstractProducts
{
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product
     */
    private $formatter;

    /**
     * Related constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Checkers\Entities\Product\Update\Related $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Product $formatter
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Checkers\Entities\Product\Update\Related $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Product $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:update:related')
            ->setDescription('Update Related Products');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     * @throws \Exception
     */
    protected function getEntities(array $inputData)
    {
        $products = [];
        $i = 0;
        foreach ($inputData as $key => $row) {
            $products[$i] = [
                'sku' => $this->formatter->skuFormatter()
            ];

            if(!empty($row['related_skus'])) {
                $products[$i] = array_merge($products[$i], [
                    'related_skus' => $this->formatter->relatedSkuFormatter(),
                    'related_position' => $this->formatter->relatedPositionFormatter(Product::FIELD_PRODUCT_RELATED)
                ]);
            }
            if(!empty($row['crosssell_skus'])) {
                $products[$i] = array_merge($products[$i], [
                    'crosssell_skus' => $this->formatter->crosssellSkuFormatter(),
                    'crosssell_position' => $this->formatter->relatedPositionFormatter(Product::FIELD_PRODUCT_CROSSSELL)
                ]);
            }
            if(!empty($row['upsell_skus'])) {
                $products[$i] = array_merge($products[$i], [
                    'upsell_skus' => $this->formatter->upsellSkuFormatter(),
                    'upsell_position' => $this->formatter->relatedPositionFormatter(Product::FIELD_PRODUCT_UPSELL)
                ]);
            }

            $i++;
        }

        return $products;
    }

    public function beforeImport()
    {
        $this->helper
            ->setBehavior(\Drop\Import\Model\Config\Source\Behavior::BEHAVIOR_UPDATE)
            ->setSheetTitle(\Drop\Import\Helper\Product::SHEET_TITLE_RELATED);
        return parent::beforeImport();
    }

}
