<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products\Updates;

use Magento\Framework\App\ObjectManagerFactory;
use \Drop\Import\Console\Command\Import\Entities\Products\AbstractProducts;

class Prices extends AbstractProducts
{
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product
     */
    private $formatter;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface\Proxy
     */
    private $productRepository;

    /**
     * Prices constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Checkers\Entities\Product $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Product $formatter
     * @param \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Checkers\Entities\Product $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Product $formatter,
        \Magento\Catalog\Api\ProductRepositoryInterface\Proxy $productRepository
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
        $this->productRepository = $productRepository;
    }

    protected function configure()
    {
        $this->setName('drop:update:prices')
            ->setDescription('Update Products Prices');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     * @throws \Exception
     */
    protected function getEntities(array $inputData)
    {
        $languages = $this->getTranslationLanguages();
        $products = [];
        $i = 0;
        foreach ($inputData as $key => $row) {
            $_product = $this->productRepository->get($this->formatter->skuFormatter());
            $simpleAssociated = $this->getSimpleAssociated($_product);
            if($_product && !empty($simpleAssociated)) {
                foreach($simpleAssociated as $simpleProduct) {
                    $simpleSku = $simpleProduct->getSku();

                    $products[$i] = [
                        'sku'             => $simpleSku,
                        'price'           => $this->formatter->priceFormatter()
                    ];
                    $i++;

                    //Translation rows
                    foreach ($languages as $language) {
                        if ($language == $this->helper->getReferenceStoreCode()) {
                            continue;
                        }

                        $this->formatter->setLanguage($language);

                        $products[$i] = [
                            'sku'             => $simpleSku,
                            'store_view_code' => $language,
                            'price'           => $this->formatter->priceFormatter()
                        ];
                        $i++;
                    }

                    $this->formatter->resetLanguage();
                }
            }
        }

        return $products;
    }

    public function beforeImport()
    {
        $this->helper
            ->setBehavior(\Drop\Import\Model\Config\Source\Behavior::BEHAVIOR_UPDATE)
            ->setSheetTitle(\Drop\Import\Helper\Product::SHEET_TITLE_PRICE);
        return parent::beforeImport();
    }

}
