<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products\Updates;

use Magento\CatalogImportExport\Model\Import\Product\Validator\Media;
use \Drop\Import\Console\Command\Import\Entities\Products\AbstractProducts;

class Images extends AbstractProducts
{
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product\Swatch
     */
    private $formatter;
    /**
     * @var \Drop\Import\Model\AttributeFactory
     */
    private $attributeFactory;

    /**
     * Images constructor.
     * @param \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Checkers\Entities\Product\Swatch $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Product\Swatch $formatter
     * @param \Drop\Import\Model\AttributeFactory $attributeFactory
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Checkers\Entities\Product\Swatch $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Product\Swatch $formatter,
        \Drop\Import\Model\AttributeFactory $attributeFactory
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        $this->attributeFactory = $attributeFactory;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:update:images')
            ->setDescription('Update Product Images');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     */
    protected function getEntities(array $inputData)
    {
        $productImagesInformation = $this->helper->getProductImagesInformation();

        $products = [];
        $i = 0;
        foreach ($inputData as $key => $row) {

            $products[$i] = [
                'sku' => $this->formatter->skuFormatter()
            ];

            // Configurable images
            foreach($productImagesInformation[$this->formatter->skuFormatter()] as $imageCounter => $imagePath) {
                foreach($this->formatter->imageRoleFormatter($imageCounter) as $imageRole) {
                    if($imageRole == Media::ADDITIONAL_IMAGES && !empty($products[$i][Media::ADDITIONAL_IMAGES])) {
                        $products[$i][$imageRole] .= ',' . $imagePath;
                    } else {
                        $products[$i][$imageRole] = $imagePath;
                    }
                }
            }

            $i++;

            $swatchVariation = $this->formatter->swatchVariationFormatter();
            if(empty($swatchVariation)) {
                // Skip swatches
                continue;
            }

            // Simple swatches associated creation
            $attributeModel = $this->attributeFactory->create();
            $superAttributeOptions = $attributeModel->getSuperAttributeOptions($row['attribute_set_code']);
            $swatchesOptions = $attributeModel->getSwatchAttributeOptions($row['attribute_set_code']);
            foreach ($swatchesOptions as $swatchAttributeCode => $swatchOptions) {
                foreach($swatchOptions as $swatchOption) {
                    if (empty($swatchOption['value']) || empty($swatchOption['label'])) {
                        continue;
                    }

                    if(!in_array($swatchOption['label'], $swatchVariation)) {
                        continue;
                    }

                    // Swatch images
                    $swatchImages = [];
                    foreach($productImagesInformation[$this->formatter->simpleAssociatedSkuFormatter($swatchOption['label'])] as $imageCounter => $imagePath) {
                        foreach($this->formatter->imageRoleFormatter($imageCounter) as $imageRole) {
                            if($imageRole == Media::ADDITIONAL_IMAGES && !empty($swatchImages[Media::ADDITIONAL_IMAGES])) {
                                $swatchImages[$imageRole] .= ',' . $imagePath;
                            } else {
                                $swatchImages[$imageRole] = $imagePath;
                            }
                        }
                    }

                    foreach ($superAttributeOptions as $superAttributeCode => $simpleOptions) {
                        foreach ($simpleOptions as $simpleOption) {
                            if (empty($simpleOption['value']) || empty($simpleOption['label'])) {
                                continue;
                            }

                            $products[$i] = array_merge([
                                'sku' => $this->formatter->simpleAssociatedSkuFormatter($swatchOption['label'] . '-' . $simpleOption['label']),
                            ], $swatchImages);
                            $i++;
                        }
                    }
                }
            }
        }

        return $products;
    }

    public function beforeImport()
    {
        $this->helper->setBehavior(\Drop\Import\Model\Config\Source\Behavior::BEHAVIOR_UPDATE);
        return parent::beforeImport();
    }

}
