<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products;

use Magento\CatalogImportExport\Model\Import\Product\Validator\Media;
use \Magento\Catalog\Model\Product\Type;

class Simple extends AbstractProducts
{
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product
     */
    private $formatter;

    /**
     * Simple constructor.
     * @param \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Checkers\Entities\Product $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Product $formatter
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Checkers\Entities\Product $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Product $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:simple')
            ->setDescription('Import Simple Products')
            ->setImportProductType(Type::TYPE_SIMPLE);

        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array|void
     */
    protected function getEntities(array $inputData)
    {
        $languages = $this->getTranslationLanguages();
        $productImagesInformation = $this->helper->getProductImagesInformation();

        $products = [];
        $i = 0;
        foreach ($inputData as $key => $row) {

            $products[$i] = [
                'sku'                => $this->formatter->skuFormatter(),
                'store_view_code'    => '',
                'attribute_set_code' => $row['attribute_set_code'],
                'product_type'       => Type::TYPE_SIMPLE,
                'product_websites'   => $row['websites'],
                'categories'         => $this->helper->getCategoryHelper()->getRootCategoryName() . '/' . $row['categories'],
                'name'               => $this->formatter->nameFormatter(),
                'description'        => $this->formatter->descriptionFormatter(),
                'price'              => $this->formatter->getProductPrice(),
                'url_key'            => $this->formatter->urlFormatter(),
                'meta_title'         => $this->formatter->metatitleFormatter(),
                'meta_description'   => $this->formatter->metadescriptionFormatter(),
                'visibility'         => $this->formatter->getProductVisibility(),
                'status'             => $this->formatter->getProductStatus(),
                'manage_stock'       => $this->formatter->getProductManageStock(),
                'weight'             => $row['weight']
            ];

            //Images
            foreach($productImagesInformation[$this->formatter->skuFormatter()] as $imageCounter => $imagePath) {
                foreach($this->formatter->imageRoleFormatter($imageCounter) as $imageRole) {
                    if($imageRole == Media::ADDITIONAL_IMAGES && !empty($products[$i][Media::ADDITIONAL_IMAGES])) {
                        $products[$i][$imageRole] .= ',' . $imagePath;
                    } else {
                        $products[$i][$imageRole] = $imagePath;
                    }
                }
            }

            //Custom attributes
            foreach($this->helper->getUserDefinedAttributes($this->getHeader(), $row['attribute_set_code']) as $userDefinedAttribute) {
                $products[$i][$userDefinedAttribute] = $row[$userDefinedAttribute];
            }

            //Translation rows
            $i++;
            foreach ($languages as $language) {
                if ($language == $this->helper->getReferenceStoreCode()) {
                    continue;
                }

                $this->formatter->setLanguage($language);

                $products[$i] = [
                    'sku'                => $this->formatter->skuFormatter(),
                    'store_view_code'    => $language,
                    'attribute_set_code' => $row['attribute_set_code'],
                    'product_type'       => Type::TYPE_SIMPLE,
                    'name'               => $this->formatter->nameFormatter(),
                    'description'        => $this->formatter->descriptionFormatter(),
                    'url_key'            => $this->formatter->urlFormatter(),
                    'meta_title'         => $this->formatter->metatitleFormatter(),
                    'meta_description'   => $this->formatter->metadescriptionFormatter()
                ];

                // Custom attributes translations
                foreach($this->helper->getUserDefinedAttributes($this->getHeader(), $row['attribute_set_code'], $language) as $userDefinedAttribute) {
                    $products[$i][$userDefinedAttribute] = $row[$userDefinedAttribute];
                }
                $i++;
            }

            $this->formatter->resetLanguage();
        }

        return $products;
    }

}
