<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products;

use \Magento\Catalog\Model\Product\Type;

class Bundle extends AbstractProducts
{
    /**
     * @var \Drop\Import\Helper\Product
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Product
     */
    private $formatter;


    /**
     * Bundle constructor.
     * @param \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Product $helper
     * @param \Drop\Import\Model\Checkers\Entities\Product $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Product $formatter
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Product $helper,
        \Drop\Import\Model\Checkers\Entities\Product $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Product $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:bundle')
            ->setDescription('Import Bundle Products')
            ->setImportProductType(Type::TYPE_BUNDLE);
        
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array|void
     */
    protected function getEntities(array $inputData)
    {
        die('<br/>' . __METHOD__ . '1');
    }

    /**
     * Import Bundles sample function
     */
//    protected function getEntities(array $inputData)
//    {
//        $simpleProducts = [];
//        $bundleProduct = array(
//            'sku' => 'Bundle-Product',
//            'attribute_set_code' => 'Default',
//            'product_type' => 'bundle',
//            'product_websites' => 'base',
//            'name' => 'FireGento Test Product Bundle',
//            'price' => '10.000',
//
//            'bundle_price_type' => 'dynamic',
//            'bundle_sku_type' => 'dynamic',
//            'bundle_price_view' => 'Price range',
//            'bundle_weight_type' => 'dynamic',
//        );
//
//        $colors = array("blue", "black");
//        $bundleValues = '';
//        for ($i = 0; $i < 2; $i++) {
//
//            $color = $colors[$i];
//            $sku = 'SIMPLE-' . $color;
//            $simpleProducts[] = array(
//                'sku' => $sku,
//                'attribute_set_code' => 'Default',
//                'product_type' => 'simple',
//                'product_websites' => 'base',
//                'name' => 'FireGento Test Product Simple - ' . $color,
//                'price' => '14.0000',
//                'additional_attributes' => "color=" . $color
//
//            );
//            $bundleAttributes = array(
//                "name" => "Color",
//                "type" => 'radio',
//                'required' => '1',
//                'sku' => $sku,
//                'price' => '14.0000',
//                'default' => $i,
//                'default_qty' => '1.0000',
//                'price_type' => 'fixed'
//            );
//
//            $bundleValues .= $this->arrayToAttributeString($bundleAttributes) . "|";
//
//        }
//        $bundleProduct["bundle_values"] = $bundleValues;
//        print_r($bundleProduct);
//
//        $data = array_merge($simpleProducts, array($bundleProduct));
//
//        return $data;
//    }

//    public function arrayToAttributeString($array)
//    {
//        $attributes_str = NULL;
//        foreach ($array as $attribute => $value) {
//            $attributes_str .= "$attribute=$value,";
//        }
//        return $attributes_str;
//    }

}
