<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Products;

use \Drop\Import\Console\Command\Import\Entities\AbstractImportEntities;

abstract class AbstractProducts extends AbstractImportEntities
{

    private $importProductType;

    /**
     * @param string $importProductType
     * @return $this
     */
    public function setImportProductType(string $importProductType) {
        $this->importProductType = $importProductType;
        return $this;
    }

    /**
     * @return string
     */
    public function getImportProductType() {
        return $this->importProductType;
    }

    /**
     * Ritorna i prodotti semplici associati ad un configurabile
     * @param $configurable
     * @return mixed
     */
    public function getSimpleAssociated($configurable) {
        return $configurable->getTypeInstance()->getUsedProducts($configurable);
    }

}
