<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Customers;

use Magento\Framework\App\ObjectManagerFactory;
use \Drop\Import\Console\Command\Import\Entities\AbstractImportEntities;

class CustomersComposite extends AbstractImportEntities
{
    /**
     * @var \Drop\Import\Helper\Customer
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Customer
     */
    private $formatter;

    /**
     * Customer constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Customer $helper
     * @param \Drop\Import\Model\Checkers\Entities\CustomerComposite $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Customer $formatter
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Customer $helper,
        \Drop\Import\Model\Checkers\Entities\CustomerComposite $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Customer $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:customer_composite')
            ->setDescription('Import Customers with Address');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     * @throws \Exception
     */
    protected function getEntities(array $inputData)
    {
        $data = [];
        $i = 0;
        foreach($inputData as $key => $row) {
            $storeByCountry = $this->helper->getStoreByCountry($row['country']);
            $websiteIdByCountry = $storeByCountry->getWebsiteId();

            $data[$i] = [
                'email' => $row['email'],
                'firstname' => $row['firstname'],
                'lastname' => $row['lastname'],

                '_website' => $this->helper->getWebsiteCodeById($websiteIdByCountry),
                '_store' => $storeByCountry->getCode(),
                'created_in' => $storeByCountry->getName(),
                'group_id' => $this->helper->getGroupId(),
                'store_id' => $storeByCountry->getId(),
                'website_id' => $websiteIdByCountry,

                'confirmation' => '',
                'disable_auto_group_change' => '0',

                'dob' => $this->formatter->dateFormatter($row['dob']),
                'gender' => $this->formatter->genderFormatter(),
                'taxvat' => $this->formatter->taxvatFormatter(),

                'created_at' => $this->formatter->dateFormatter($row['created_at']),
                'updated_at' => $this->formatter->dateFormatter($row['updated_at']),

                'ip_address' => $this->formatter->ipAddressFormatter(),
                'is_privacy_policy_accepted' => $this->formatter->privacyFormatter(),
                'is_profiling_accepted' => $this->formatter->profilingFormatter(),

//                'middlename' => '',
//                'password_hash' => '',
//                'prefix' => '',
//                'rp_token' => '',
//                'rp_token_created_at' => '',
//                'suffix' => '',
//                'password' => ''

                '_address_firstname' => $row['firstname'],
                '_address_lastname' => $row['lastname'],
                '_address_telephone' => $row['telephone'],
                '_address_vat_id' => $row['vat_id'],
                '_address_default_billing_' => 1,
                '_address_default_shipping_' => 1,
                '_address_company' => $row['company'],

//                '_address_middlename' => $row['middlename'],
//                '_address_prefix' => $row['prefix'],
//                '_address_suffix' => $row['suffix'],

                'customer_typology' => $row['customer_typology'],
                'request_invoice' => $row['request_invoice'],
                'fe_reception_destination' => $row['fe_reception_destination'],
                'fiscal_code' => $row['fiscal_code'],

                '_address_street' => $row['street'],
                '_address_city' => $row['city'],
                '_address_postcode' => $row['postcode'],
                '_address_region' => $row['region'],
                '_address_country_id' => $row['country']
            ];

            //TODO: Not tested from here
            $address = $this->formatter->addressFormatter();
            $storeAddress = $this->formatter->storeAddressFormatter($address);
            $geocodedStoreAddress = $this->helper->geocodeAddress($storeAddress);
            if($this->helper->geocodeModuleExist() && !empty($geocodedStoreAddress)) {
                $geocodedRoute = $geocodedStoreAddress['route'] . ', ' . $geocodedStoreAddress['street_number'];
                $data[$i] = array_merge($data[$i], [
                    '_address_city' => $geocodedStoreAddress['locality'],
                    '_address_country_id' => $geocodedStoreAddress['country'],
                    '_address_postcode' => $geocodedStoreAddress['postal_code'],
                    '_address_region' => $geocodedStoreAddress['region'],
                    '_address_street' => $geocodedRoute
                ]);
            }

            //TODO: newsletter

            $i++;
        }

        return $data;
    }

    public function beforeImport()
    {
        $this->helper->setCompositeEntityCode();
        return parent::beforeImport();
    }

}



