<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities\Customers;

use Magento\Framework\App\ObjectManagerFactory;
use \Drop\Import\Console\Command\Import\Entities\AbstractImportEntities;

class Customers extends AbstractImportEntities
{
    /**
     * @var \Drop\Import\Helper\Customer
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Customer
     */
    private $formatter;

    /**
     * Customer constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Customer $helper
     * @param \Drop\Import\Model\Checkers\Entities\Customer $checker
     * @param \Magento\Framework\App\State $state
     * @param \Drop\Import\Model\Formatter\Customer $formatter
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Customer $helper,
        \Drop\Import\Model\Checkers\Entities\Customer $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Customer $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:customers')
            ->setDescription('Import Customers without Address');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     */
    protected function getEntities(array $inputData)
    {
        $data = [];
        $i = 0;
        foreach($inputData as $key => $row) {
            $storeByCountry = $this->helper->getStoreByCountry($row['country']);
            $websiteIdByCountry = $storeByCountry->getWebsiteId();

            $data[$i] = [
                'email' => $row['email'],
                'firstname' => $row['firstname'],
                'lastname' => $row['lastname'],

                '_website' => $this->helper->getWebsiteCodeById($websiteIdByCountry),
                '_store' => $storeByCountry->getCode(),
                'created_in' => $storeByCountry->getName(),
                'group_id' => $this->helper->getGroupId(),
                'store_id' => $storeByCountry->getId(),
                'website_id' => $websiteIdByCountry,

                'confirmation' => '',
                'disable_auto_group_change' => '0',

                'dob' => $this->formatter->dateFormatter($row['dob']),
                'gender' => $this->formatter->genderFormatter(),
                'taxvat' => $this->formatter->taxvatFormatter(),

                'created_at' => $this->formatter->dateFormatter($row['created_at']),
                'updated_at' => $this->formatter->dateFormatter($row['updated_at']),

                'ip_address' => $this->formatter->ipAddressFormatter(),
                'is_privacy_policy_accepted' => $this->formatter->privacyFormatter(),
                'is_profiling_accepted' => $this->formatter->profilingFormatter()

//                'middlename' => '',
//                'password_hash' => '',
//                'prefix' => '',
//                'rp_token' => '',
//                'rp_token_created_at' => '',
//                'suffix' => '',
//                'password' => ''
            ];

            $i++;
        }
        return $data;
    }

    public function beforeImport()
    {
        $this->helper->setCustomerEntityCode();
        return parent::beforeImport();
    }

}



