<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities;

use Magento\Framework\App\ObjectManagerFactory;

class Categories extends AbstractImportEntities
{
    /**
     * @var \Drop\Import\Helper\Category
     */
    private $helper;
    /**
     * @var \Drop\Import\Model\Formatter\Category
     */
    private $formatter;

    /**
     * Category constructor.
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Category $helper
     * @param \Drop\Import\Model\Checkers\Entities\Category $checker
     * @param \Drop\Import\Model\Formatter\Category $formatter
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Category $helper,
        \Drop\Import\Model\Checkers\Entities\Category $checker,
        \Magento\Framework\App\State $state,
        \Drop\Import\Model\Formatter\Category $formatter
    )
    {
        $this->helper = $helper;
        $this->formatter = $formatter;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:categories')
            ->setDescription('Import Categories');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     * @throws \Exception
     */
    protected function getEntities(array $inputData)
    {
        $translationLanguages = $this->getTranslationLanguages();
        $referenceStoreCode = $this->helper->getReferenceStoreCode();
        $referenceStoreId = $this->helper->getStoreIdByCode($referenceStoreCode);
        $rootCategoryName = $this->helper->getRootCategoryName($referenceStoreId);

        $data = [];
        $i = 0;
        foreach($inputData as $row) {
            $this->formatter->setRow($row);

            $data[$i]['_root'] = $rootCategoryName;
            $data[$i]['_category'] = $this->formatter->nameFormatter();
            $data[$i]['meta_title'] = $this->formatter->metatitleFormatter();
            $data[$i]['meta_description'] = $this->formatter->metadescriptionFormatter();
            $data[$i]['url_key'] = $this->formatter->urlkeyFormatter();

            $data[$i]['is_active'] = $this->formatter->getCategoryIsActive();
            $data[$i]['include_in_menu'] = $this->formatter->getCategoryIncludeInMenu();
            $data[$i]['available_sort_by'] = $this->formatter->getCategoryAvailableSortBy();
            $data[$i]['default_sort_by'] = $this->formatter->getCategoryDefaultSortBy();
            $data[$i]['is_anchor'] = $this->formatter->getCategoryIsAnchor();
            $i++;

            foreach($translationLanguages as $language) {
                if($language == $referenceStoreCode) {
                    continue;
                }

                $this->formatter->setLanguage($language);

                //Store category translation
                $data[$i]['_store'] = $language;
                $data[$i]['name'] = $this->formatter->nameFormatter();
                $data[$i]['meta_title'] = $this->formatter->metatitleFormatter();
                $data[$i]['meta_description'] = $this->formatter->metadescriptionFormatter();
                $data[$i]['url_key'] = $this->formatter->urlkeyFormatter();
                $i++;
            }

            $this->formatter->resetLanguage();
        }

        return $data;
    }

}



