<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities;

use Magento\Framework\App\ObjectManagerFactory;

class AttributesSet extends AbstractImportEntities
{
    /**
     * @var \Drop\Import\Helper\AttributeSet
     */
    private $helper;

    /**
     * AttributesSet constructor.
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\AttributeSet $helper
     * @param \Drop\Import\Model\Checkers\Entities\AttributeSet $checker
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\AttributeSet $helper,
        \Drop\Import\Model\Checkers\Entities\AttributeSet $checker,
        \Magento\Framework\App\State $state
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }    

    protected function configure()
    {
        $this->setName('drop:import:attributeset')
            ->setDescription('Import Attribute Sets');
        parent::configure();
    }

    /**
     * @param array $inputData
     * @return array
     */
    protected function getEntities(array $inputData)
    {
        $languages = $this->getTranslationLanguages();
        $normalizedData = $this->normalizeData($inputData);

        $data = [];
        $i = 0;
        foreach($normalizedData as $key => $row) {
            $data[$i] = [
                'attribute_set_name' => $row['attribute_set_name'],
                'attribute_code' => $row['attribute_code'],
                'frontend_label' => $row['frontend_label'],
                'option_store' => '',
                'option_value' => $row['option_value']
            ];
            $i++;

            //Translation rows
            foreach($languages as $language) {
                if($language == $this->helper->getReferenceStoreCode()) {
                    continue;
                }

                $data[$i] = [
                    'attribute_set_name' => $row['attribute_set_name'],
                    'attribute_code' => $row['attribute_code'],
                    'frontend_label' => $row['frontend_label_' . $language],
                    'option_store' => $language,
                    'option_value' => $row['option_value_' . $language]
                ];

                $i++;
            }
        }

        return $data;
    }

    private function normalizeData(array $inputData) {
        $languages = $this->getTranslationLanguages();
        $normalizedData = [];
        foreach($inputData as $key => $row) {

            if(!array_key_exists($row['codice'], $normalizedData)) {
                $normalizedData[$row['codice']] = [
                    'attribute_set_name' => $row['codice'],
                    'attribute_code' => $row['codice'],
                    'frontend_label' => $row['scaletaglie'],
//                'option_store' => '',
                    'option_value' => ''
                ];
            }

            if(!empty($normalizedData[$row['codice']]['option_value'])) {
                $normalizedData[$row['codice']]['option_value'] .= '|';
            }
            $normalizedData[$row['codice']]['option_value'] .= $row['taglia'];

            //Translation rows
            foreach($languages as $language) {
                if($language == $this->helper->getReferenceStoreCode()) {
                    continue;
                }

                $normalizedData[$row['codice']]['frontend_label_' . $language] = $row['scaletaglie_' . $language];

                if(empty($normalizedData[$row['codice']]['option_value_' . $language])) {
                    $normalizedData[$row['codice']]['option_value_' . $language] = '';
                }

                if(!empty($normalizedData[$row['codice']]['option_value_' . $language])) {
                    $normalizedData[$row['codice']]['option_value_' . $language] .= '|';
                }
                $normalizedData[$row['codice']]['option_value_' . $language] .= $row['taglia_' . $language];

            }
        }

        return $normalizedData;
    }
    
}
