<?php
/**
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Import\Console\Command\Import\Entities;

use Magento\Framework\App\ObjectManagerFactory;

class Attributes extends AbstractImportEntities
{
    /**
     * @var \Drop\Import\Helper\Attribute
     */
    private $helper;

    private $multiAttributeTypology = ['select','multiselect'];

    /**
     * Attributes constructor.
     * @param \Magento\Framework\File\Csv $csvProcessor
     * @param \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory
     * @param \Drop\Import\Logger\Logger $logger
     * @param \Drop\Import\Helper\Attribute $helper
     * @param \Drop\Import\Model\Checkers\Entities\Attribute $checker
     * @param ObjectManagerFactory $objectManagerFactory
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
        \Magento\Framework\App\ObjectManagerFactory $objectManagerFactory,
        \Magento\Framework\File\Csv $csvProcessor,
        \Drop\GoogleApiAdapter\Model\Service\SpreadsheetsFactory $spreadsheetsFactory,
        \Drop\Import\Logger\Logger $logger,
        \Drop\Import\Helper\Attribute $helper,
        \Drop\Import\Model\Checkers\Entities\Attribute $checker,
        \Magento\Framework\App\State $state
    )
    {
        $this->helper = $helper;
        parent::__construct($objectManagerFactory, $csvProcessor, $spreadsheetsFactory, $logger, $helper, $checker, $state);
    }

    protected function configure()
    {
        $this->setName('drop:import:attributes')
            ->setDescription('Import Attributes');
        parent::configure();
    }


    /**
     * @param array $inputData
     * @return array $attributes
     */
    protected function getEntities(array $inputData)
    {
        $languages = $this->getTranslationLanguages();
        $normalizedData = $this->normalizeData($inputData);

        $attributes = [];
        $i = 0;
        foreach($normalizedData as $data) {
            $attributes[$i] = [
                'attribute_code' => $data['attribute_code'],
                'frontend_input' => $data['frontend_input'],
                'frontend_label' => $data['frontend_label'],
                'scope' => $data['scope'],
                'option_store'   => $data['option_store'],
                'option_value' => $data['option_value']
            ];
            $i++;

            foreach ($languages as $language) {
//                if($language == $this->helper->getReferenceStoreCode()) {
//                    continue;
//                }
                if(empty($data['option_value_' . $language])) {
                    continue;
                }

                $attributes[$i] = [
                    'attribute_code' => $data['attribute_code'],
                    'frontend_input' => $data['frontend_input'],
                    'frontend_label' => $data['frontend_label_' . $language],
                    'scope' => $data['scope'],
                    'option_store'   => $language,
                    'option_value' => $data['option_value_' . $language]
                ];
                $i++;
            }
        }

        return $attributes;
    }

    private function normalizeData(array $inputData) {
        $languages = $this->getTranslationLanguages();
        $normalizedData = [];
        foreach ($inputData as $key => $row) {
            if(!array_key_exists($row['attributo'], $normalizedData)) {
                $normalizedData[$row['attributo']] = [
                    'attribute_code' => $row['attributo'],
                    'frontend_input' => $row['tipo'],
                    'frontend_label' => $row['etichetta'],
                    'scope' => $row['scope'],
                    'option_store'   => '',
                    'option_value' => ''
                ];
            }

            if(empty($row['valori'])) {
                continue;
            }

            // Multiselect management
            if(in_array($row['tipo'], $this->multiAttributeTypology) && !empty($normalizedData[$row['attributo']]['option_value'])) {
                $normalizedData[$row['attributo']]['option_value'] .= '|';
            }

            $normalizedData[$row['attributo']]['option_value'] .= $row['valori'];

            // Translations
            foreach ($languages as $language) {
//                if($language == $this->helper->getReferenceStoreCode()) {
//                    continue;
//                }

                if(empty($row['valori_' . $language])) {
                    continue;
                }

                $normalizedData[$row['attributo']]['frontend_label_' . $language] = $row['etichetta_' . $language];

                if(empty($normalizedData[$row['attributo']]['option_value_' . $language])) {
                    $normalizedData[$row['attributo']]['option_value_' . $language] = '';
                }
                // Multiselect management
                if(in_array($row['tipo'], $this->multiAttributeTypology) && !empty($normalizedData[$row['attributo']]['option_value_' . $language])) {
                    $normalizedData[$row['attributo']]['option_value_' . $language] .= '|';
                }
                $normalizedData[$row['attributo']]['option_value_' . $language] .= $row['valori_' . $language];
            }
        }

        return $normalizedData;
    }


}
