<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 28/02/2019
 * File name: CreateRmaShipment.php
 * Project: drop/module-gsped
 */
namespace Drop\Gsped\Observer;

class CreateShipment implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Drop\Gsped\Model\Gsped\Shipment
     */
    private $shipment;

    /**
     * CreateRmaShipment constructor.
     * @param \Drop\Gsped\Model\Gsped\Shipment $shipment
     */
    public function __construct(
        \Drop\Gsped\Model\Gsped\Shipment $shipment
    ){
        $this->shipment = $shipment;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $shipmentInfo = $observer->getData("shipment_info");
        $this->shipment->createShipment($shipmentInfo);
    }
}