<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 28/02/2019
 * File name: Data.php
 * Project: drop/module-gsped
 */
namespace Drop\Gsped\Helper;
use Magento\Framework\App\Helper\Context;

/**
 * Class Data
 *
 * @package Drop\Geolocation\Helper\Core
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Data constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param Context $context
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        Context $context
    )
    {
        $this->scopeConfig = $scopeConfig;
        parent::__construct( $context );
    }

    public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Base configurations
     * @return mixed
     */
    public function getActive(){
        return $this->getConfig("dropgsped/configuration/active");
    }
    public function getApiKey(){
        return $this->getConfig("dropgsped/configuration/api_key");
    }

    public function getApiBaseUrl(){
        return $this->getConfig("dropgsped/configuration/api_base_url");
    }

    public function getClientId(){
        return $this->getConfig("dropgsped/configuration/client_id");
    }

    public function getRmaClientId(){
        return $this->getConfig("dropgsped/configuration/rma_client_id");
    }

    public function getSaveLabel(){
        return $this->getConfig("dropgsped/configuration/save_label");
    }

    public function getEnableSynkLog(){
        return $this->getConfig("dropgsped/configuration/enable_synk_log");
    }

    /**
     * Return carrier information for standard shipment
     * @return array
     */
    public function getCarrierCode()
    {
        return $this->getConfig( "dropgsped/carrier/carrier_code" );
    }

    public function getCarrierService(){
        return $this->getConfig("dropgsped/carrier/carrier_service");
    }

    /**
     * Return carrier information for ITALY rma shipment
     * @return array
     */
    public function getRmaCarrierCode()
    {
        return $this->getConfig( "dropgsped/rma_carrier/rma_carrier_code" );
    }
    public function getRmaCarrierService(){
        return $this->getConfig("dropgsped/rma_carrier/rma_carrier_service");
    }

    /**
     * Return carrier information for INTERNATIONAL rma shipment
     * @return array
     */
    public function getInternationalRmaCarrierCode()
    {
        return $this->getConfig( "dropgsped/rma_carrier_international/rma_carrier_code" );
    }
    public function getInternationalRmaCarrierService(){
        return $this->getConfig("dropgsped/rma_carrier_international/rma_carrier_service");
    }

    /**
     * Connection timeout
     * @return mixed
     */
    public function getConnectionTimeout(){
        return $this->getConfig("dropgsped/configuration/connection_timeout");
    }

    public function getTimeout(){
        return $this->getConfig("dropgsped/configuration/timeout");
    }

    public function getReadTimeout(){
        return $this->getConfig("dropgsped/configuration/read_timeout");
    }
}