<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 28/02/2019
 * File name: CreateRemShipment.php
 * Project: drop/module-gsped
 */
namespace Drop\Gsped\Controller\Test;

class Shipment extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Drop\Gsped\Model\Gsped\Shipment
     */
    private $shipment;
    /**
     * @var \Magento\Framework\Event\Manager
     */
    private $eventManager;
    /**
     * @var GspedInterface
     */
    private $gsped;
    /**
     * @var \Drop\Gsped\Api\Data\GspedInterface
     */
    private $helper;


    /**
     * Shipment constructor.
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Drop\Gsped\Model\Gsped\Shipment $shipment
     * @param \Drop\Gsped\Api\Data\GspedInterface $gsped
     * @param \Drop\Gsped\Api\Data\GspedInterface $helper
     * @param \Magento\Framework\Event\Manager $eventManager
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Drop\Gsped\Model\Gsped\Shipment $shipment,
        \Drop\Gsped\Api\Data\GspedInterface $gsped,
        \Drop\Gsped\Helper\Data $helper,
        \Magento\Framework\Event\Manager $eventManager

    ){
        $this->shipment = $shipment;
        $this->eventManager = $eventManager;
        $this->gsped = $gsped;
        $this->helper = $helper;
        parent::__construct($context);
    }

    public function execute()
    {
        $data=[
            "colli" => 1,
            "corriere" => $this->helper->getRmaCarrierCode(),
            "servizio" => $this->helper->getRmaCarrierService(),
            "ddt_num" => "10000020",
            "ddt_alpha" => "10000020",
            "peso" => 1,
            "date_req_ritiro" => "2019-03-04 09:00:00",
            "opening_time" => "10:00",
            "closing_time" => "12:00",

            "rcpt_addr" => "via Fratelli Cervi, 46",
            "rcpt_cap" => "62010",
            "rcpt_city" => "Montecosaro",
            "rcpt_contact" => "Simone Monterubbiano",
            "rcpt_country_code" => "IT",
            "rcpt_email" => "s.monterubbiano@drop.it",
            "rcpt_name" => "Simone Monterubbiano",
            "rcpt_phone" => "3272372",
            "rcpt_prov" => "MC",

            "sender_addr" => "via Fratelli Cervi, 46",
            "sender_cap" => "62010",
            "sender_city" => "Montecosaro",
            "sender_contact" => "Simone Monterubbiano",
            "sender_country_code" => "IT",
            "sender_email" => "s.monterubbiano@drop.it",
            "sender_name" => "Simone Monterubbiano",
            "sender_phone" => "3272372",
            "sender_prov" => "MC",
        ];

        // Call model
        $result = $this->gsped->createRemShipment($data);

        // Dispatch event
        //$result = $this->eventManager->dispatch("gsped_create_rma_shipment",["shipment_info"=>$sender]);
        echo "<pre>";
        print_r($result);
        echo "</pre>";
        die(__METHOD__);
    }
}