<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 07/03/2019
 * File name: GetShipment.php
 * Project: drop/module-gsped
 */
namespace Drop\Gsped\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;

class GetTracking extends Command
{
    const DDT_NUM = 'ddt_num';
    /**
     * @var \Drop\Gsped\Api\Data\GspedInterface
     */
    private $gspedInterface;

    /**
     * GetShipment constructor.
     * @param \Drop\Gsped\Api\Data\GspedInterface $gspedInterface
     */
    public function __construct(
        \Drop\Gsped\Api\Data\GspedInterface $gspedInterface
    )
    {
        $this->gspedInterface = $gspedInterface;
        parent::__construct();
    }

    /**
     * For example call:
     * php v1.0.0/bin/magento drop:gsped:getshipment --id="68385979"
     */
    protected function configure()
    {
        // rmaId option
        $options = [
            new InputOption(
                self::DDT_NUM,
                null,
                InputOption::VALUE_REQUIRED,
                'Gsped ddt_num'
            )
        ];

        $this->setName('drop:gsped:gettracking')
            ->setDescription('Get tracking information by ddt_num and print all information')
            ->setDefinition($options);
        parent::configure();
    }

    /**
     * For example: php v1.0.0/bin/magento drop:gsped:gettracking --ddt_num="000000011"
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|null|void
     */
    public function execute( InputInterface $input, OutputInterface $output )
    {
        echo PHP_EOL;
        $ddt_num = $input->getOption( self::DDT_NUM );

        $result = $this->gspedInterface->getTracking($ddt_num);
        echo "<pre>";
        print_r($result);
        echo "</pre>";
    }
}