# DROP GSPED MAGENTO 2 INTEGRATION

## FIXES
Adding afterSave to Shipment REST API Creation to fix an issue in Magento2 causes an order's status to remain unchanged when the order is shipped via the API shipment creation does not update the qty_shipped for an order's sales_order_items, preventing the order state and status from changing.

## FEATURES

#### Shipping creation
Creates Gsped shipment, save label to file system (under pub/gsped folder)

Return array with label_path, label_base64_encoded and tracking_link

Other modules can call Drop\Gsped\Api\Data\GspedInterface createShipment and getShipment methods.

Other modules can dispatch "gsped_create_shipment" event passing the shipment information array in shipment_info param and this module creates the shipment

#### Shipping get information
Other modules can call Drop\Gsped\Api\Data\GspedInterface getShipment to retrieve shipment information

#### Log information
All responses body are saved on pub/gsped/response_body folder in json format

#### Example array for shipping creation
Here an example of array to pass to Gsped method interface for creating a shipment:

```
Array
(
    [client_id] => 590 // Call Drop\Gsped\Helper\Data getClientId() method
    [corriere] => 1    // Call Drop\Gsped\Helper\Data getCarrierCode() method
    [servizio] => 0    // Call Drop\Gsped\Helper\Data getCarrierService() method
    
    [colli] => 1
    [ddt_alpha] => 000000009 //Alfanumeric order referral
    [peso] => 1
    
    [sender_name] => Simone Monterubbiano
    [sender_addr] => Via Enrico Fermi, 17
    [sender_cap] => 62010
    [sender_city] => Appignano
    [sender_contact] => Simone Monterubbiano
    [sender_prov] => MC
    [sender_country_code] => IT
    [sender_email] => s.monterubbiano@drop.it
    [sender_phone] => +39073340079
    
    [rcpt_addr] => Via Enrico Fermi, 17
    [rcpt_cap] => 62010
    [rcpt_city] => Appignano
    [rcpt_prov] => MC // (2 digit code)
    [rcpt_contact] => Paoloni
    [rcpt_country_code] => IT // (2 digit code)
    [rcpt_email] => shoponline@manuelritz.com
    [rcpt_name] => Paoloni
    [rcpt_phone] => 39073340079
)
```

#### RMA shipping creation
If you have to create a RMA shipment you have to add: 

```
[reso] => 1
[date_req_ritiro] => 2019-02-05, //(DATE FORMAT) YYYY-MM-DD 
[opening_time] => 10:00, //(STRING) - Ora pronta merce
[closing_time] => 10:00, //(STRING) - Ora chiusura
```