<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 07/03/2019
 * File name: GetShipment.php
 * Project: drop/module-gsped
 */
namespace Drop\Gsped\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;

class GetShipment extends Command
{
    const ID = 'id';
    /**
     * @var \Drop\Gsped\Api\Data\GspedInterface
     */
    private $gspedInterface;

    /**
     * GetShipment constructor.
     * @param \Drop\Gsped\Api\Data\GspedInterface $gspedInterface
     */
    public function __construct(
        \Drop\Gsped\Api\Data\GspedInterface $gspedInterface
    )
    {
        $this->gspedInterface = $gspedInterface;
        parent::__construct();
    }

    protected function configure()
    {
        // rmaId option
        $options = [
            new InputOption(
                self::ID,
                null,
                InputOption::VALUE_REQUIRED,
                'Gsped shipment id'
            )
        ];

        $this->setName('drop:gsped:getshipment')
            ->setDescription('Get shipment by gsped shipment id and print all information')
            ->setDefinition($options);
        parent::configure();
    }

    /**
     * For example: php v1.0.0/bin/magento drop:gsped:getshipment --id="68385979"
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|null|void
     */
    public function execute( InputInterface $input, OutputInterface $output )
    {
        echo PHP_EOL;
        $id = $input->getOption( self::ID );

        $result = $this->gspedInterface->getShipment($id);
        echo "<pre>";
        print_r($result);
        echo "</pre>";
    }
}