<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 01/03/2019
 * File name: GspedInterface.php
 * Project: drop/module-gsped
 */

namespace Drop\Gsped\Api\Data;

interface GspedInterface
{

    /**
     * @param $data
     * $data = [
     * "client_id": (string) required
     * "colli": (string) required
     * "corriere": (string)
     * "servizio": (string)
     * "ddt_alpha": (string)
     * "ddt_num": (string)
     * "peso": (int)
     * "volume": (string)
     * "status": (string)
     * "date_req_ritiro": (datetime)
     * "opening_time": (date)
     * "closing_time": (date)
     *
     * "rcpt_addr": (string) required
     * "rcpt_cap": (string) required
     * "rcpt_city": (string) required
     * "rcpt_contact": (string) required
     * "rcpt_country_code": (string) required
     * "rcpt_email": (string) required
     * "rcpt_name": (string) required
     * "rcpt_phone": (string) required
     * "rcpt_prov": (string) required
     * "sender_name": (string) required
     * "sender_addr": (string) required
     * "sender_cap": (string) required
     * "sender_city": (string) required
     * "sender_contact": (string) required
     * "sender_prov": (string) required
     * "sender_country_code": (string) required
     * "sender_email": (string) required
     * "sender_phone": (string) required
     * ]
     * @return mixed
     */
    public function createShipment(array $data);

    /**
     * @param $id
     * @return mixed
     *
     */
    public function getShipment($id);

    /**
     * @param $ddt_num
     * @return mixed
     */
    public function getTracking($ddt_num);

    /**
     * @param array $data
     * @return mixed
     */
    public function getRate(array $data);
}