<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 12/06/2019
 * Time: 14:12
 */

namespace Drop\GoogleCloud\Helper;

class Data
{
    private $encryptor;
    private $scope;

    public function __construct(
        \Magento\Framework\Encryption\EncryptorInterface $encryptor,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    )
    {
        $this->encryptor = $encryptor;
        $this->scope = $scopeConfig;
    }

    public function getAccountType()
    {
        return $this->encryptor->decrypt($this->scope->getValue('google_cloud/http_cache_host/type'));
    }

    public function getHttpCacheHostRewriteIsEnabled()
    {
        return $this->scope->getValue('google_cloud/http_cache_host/enabled');
    }

    public function getZone()
    {
        return $this->encryptor->decrypt($this->scope->getValue('google_cloud/http_cache_host/zone'));
    }

    public function getProjectId()
    {
        return $this->encryptor->decrypt($this->scope->getValue('google_cloud/http_cache_host/project_id'));
    }

    public function getPrivateKey()
    {
        $var = explode('\n', $this->encryptor->decrypt($this->scope->getValue('google_cloud/http_cache_host/private_key')));
        $elaborated = '';
        foreach ($var as $item) {
            $elaborated .= "\n" . $item;
        }

        return $elaborated;
    }

    public function getClientEmail()
    {
        return $this->encryptor->decrypt($this->scope->getValue('google_cloud/http_cache_host/client_email'));
    }
}
