<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 03/06/2019
 * Time: 15:04
 */

namespace Drop\GoogleCloud\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Magento\Framework\App\ObjectManager;

class Update extends Command
{
    /**
     * @var Drop\GoogleCloud\Model\Update
     */
    private $update;

    public function __construct(
        \Drop\GoogleCloud\Model\Update $update,
        \Drop\GoogleCloud\Helper\Data $helper
    )
    {
        $this->update = $update;
        $this->helper = $helper;

        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('drop:gc-update:server');
        $this->setDescription('Update varnish server');
        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if(!$this->helper->getHttpCacheHostRewriteIsEnabled()) {
            return false;
        }

        $this->update->process();
    }
}
