<?php
/**
 * Callback
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\GoogleApiAdapter\Controller\Index;

class Callback extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    protected $_request;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;
    /**
     * @var \Drop\GoogleApiAdapter\Model\Connection
     */
    private $connection;

    /**
     * Callback constructor.
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Drop\GoogleApiAdapter\Model\Connection $connection
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Drop\GoogleApiAdapter\Model\Connection $connection,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->connection = $connection;
        $this->_request = $context->getRequest();
        $this->logger = $logger;

        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        if($this->_request->isAjax()) {
            return false;
        }

        $authCode = $this->_request->getParam('code');
        if(empty($authCode)) {
            return false;
        }

        try {
            $this->connection->initClient()
                ->setAccessTokenByAuthCode($authCode);
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
            throw new \Exception($e->getMessage());
        }

        $resultPage =  $this->resultPageFactory->create();
        $resultPage->getConfig()->getTitle()->set(__('Successfully connected to Google API'));
        return $resultPage;
    }
}
