<?php
/**
 * Authorize
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\GoogleApiAdapter\Controller\Adminhtml\Index;

class Authorize extends \Magento\Backend\App\Action
{

    /**
     * @var \Drop\GoogleApiAdapter\Model\Connection
     */
    private $connection;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;
    /**
     * @var \Drop\GoogleApiAdapter\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    /**
     * Authorize constructor.
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Drop\GoogleApiAdapter\Model\Connection $connection
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     * @param \Drop\GoogleApiAdapter\Helper\Data $helper
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Drop\GoogleApiAdapter\Model\Connection $connection,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Drop\GoogleApiAdapter\Helper\Data $helper,
        \Psr\Log\LoggerInterface $logger
    ) {
        parent::__construct($context);

        $this->connection = $connection;
        $this->request = $context->getRequest();
        $this->messageManager = $messageManager;
        $this->helper = $helper;
        $this->logger = $logger;
    }

    /**
     * @return string
     */
    public function execute()
    {
        if(!$this->request->isAjax()) {
            return false;
        }

        $result = false;
        try {
            if(!$this->helper->getGoogleApiIsConnected()) {
                $result = $this->connection->authorize();
            } else {
                $this->messageManager->addSuccessMessage(__('Successfully connected to Google API'));
            }

        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
            $this->messageManager->addErrorMessage($e->getMessage());
        }

        $resultJson = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON);
        $resultJson->setData($result);
        return $resultJson;
    }

}
