<?php
/**
 * Buttons
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\GoogleApiAdapter\Block\Adminhtml\System\Config;

class Buttons extends \Magento\Config\Block\System\Config\Form\Field
{
    const CONNECT_BUTTON_ID = 'connect-to-google-api';
    const REVOKE_BUTTON_ID = 'revoke-google-api-connection';

    protected $_template = 'Drop_GoogleApiAdapter::system/config/buttons.phtml';

    /**
     * @var \Drop\GoogleApiAdapter\Helper\Data
     */
    private $helper;

    /**
     * Buttons constructor.
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Drop\GoogleApiAdapter\Helper\Data $helper
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Drop\GoogleApiAdapter\Helper\Data $helper,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->helper = $helper;
    }

    /**
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     */
    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        return $this->_toHtml();
    }

    /**
     * @return string
     */
    public function getConnectAjaxUrl()
    {
        return $this->getUrl('googleapiadapter/index/authorize');
    }

    /**
     * @return string
     */
    public function getRevokeAjaxUrl()
    {
        return $this->getUrl('googleapiadapter/index/revoke');
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getConnectButtonHtml()
    {
        $buttonData = [
            'id' => $this->getConnectGoogleApiButtonId(),
            'label' => __('Connect to Google API'),
            'class' => 'action-default scalable save primary ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only'
        ];

        if($this->getGoogleApiIsConnected()) {
            $buttonData['disabled'] = true;
        }

        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData($buttonData);

        return $button->toHtml();
    }

    /**
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getRevokeButtonHtml()
    {
        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData([
            'id' => $this->getRevokeGoogleApiButtonId(),
            'label' => __('Revoke Connection')
        ]);

        return $button->toHtml();
    }

    /**
     * @return mixed
     */
    public function getCredentialJsonIsUploaded()
    {
        return $this->helper->getCredentialJsonUploader();
    }

    /**
     * @return bool
     */
    public function getGoogleApiIsConnected()
    {
        return $this->helper->getGoogleApiIsConnected();
    }

    public function getConnectGoogleApiButtonId() {
        return self::CONNECT_BUTTON_ID;
    }

    public function getRevokeGoogleApiButtonId() {
        return self::REVOKE_BUTTON_ID;
    }

}
