<?php

namespace Drop\GestpayPro\Plugin\WS;

/**
 * CryptDecrypt class
 */
class CryptDecrypt
{
	/**
	 * Construct
	 * @param \Drop\GestpayPro\Helper\Data $helper
	 */
	public function __construct(
		\Drop\GestpayPro\Helper\Data $helper
	)
	{
		$this->helper = $helper;
	}

	/**
	 * Hook before
	 * @param  \EasyNolo\BancaSellaPro\Model\WS\CryptDecrypt $subjet 
	 * @param  array                                        $params 
	 * @return array                                                
	 */
	public function beforeGetEncryptString(
		\EasyNolo\BancaSellaPro\Model\WS\CryptDecrypt $subjet,
		$params
	)
	{
		if($this->helper->getSecurityType() == \Drop\GestpayPro\Model\Config\Source\Security::APIKEY){
			$params['apikey'] = $this->helper->getApiKey();
			return array($params);
		}
	}
	
	/**
	 * Hook before
	 * @param  \EasyNolo\BancaSellaPro\Model\WS\CryptDecrypt $subjet 
	 * @param  array                                        $params 
	 * @return array                                                
	 */
	public function beforeDecryptRequest(
		\EasyNolo\BancaSellaPro\Model\WS\CryptDecrypt $subjet,
		$params
	)
	{
		if($this->helper->getSecurityType() == \Drop\GestpayPro\Model\Config\Source\Security::APIKEY){
			$params['apikey'] = $this->helper->getApiKey();
			return array($params);
		}
	}
}