<?php

namespace Drop\GestpayPro\Helper;

/**
 * Data class
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Construct
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig 
     * @param \Magento\Framework\App\Helper\Context              $context     
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Helper\Context $context
    )
    {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * @param  string $configPath 
     * @return string             
     */
    private function getConfig($configPath)
    {
        return $this->scopeConfig->getValue(
            $configPath,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return int
     */
    public function getSecurityType(){
        return $this->getConfig("dropgestpaypro/configuration/security_check");
    }

    /**
     * @return string
     */
    public function getApiKey(){
        return $this->getConfig("dropgestpaypro/configuration/security_check_apikey");
    }
}