<?php
/*
 * Description: OrderPlaceAfter.php
 * @date: 16-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Observer\Order;

class CancelAfter implements \Magento\Framework\Event\ObserverInterface
{
    protected $publisher;
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;

    /**
     * CancelAfter constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\Gestionale\Logger\Logger $logger
    ) {
        $this->publisher = $publisher;
        $this->logger = $logger;
    }
    
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $incrementId = $observer->getOrder()->getIncrementId();

        // If incrementId is empty, return
        if(empty($incrementId)){
            $this->logger->critical("[GENERATE-XML-FILE] - IncrementId from observer is empty",["method"=>__METHOD__]);
            return $this;
        }

        // Create job
        $this->publisher->publish('order_cancel_after', "#{$incrementId} - Order canceled - Generate XML", $observer->getEvent()->getOrder()->getId());
        $this->logger->info("[GENERATE-XML-FILE] - Created job order_cancel_after",["method"=>__METHOD__,"incrementId"=>$incrementId]);

        return $this;
    }
}