<?php

/*
 * Description: Data.php
 * @date: 11-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Gestionale\Helper;

use Magento\Store\Model\ScopeInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper{

    // Drop GESTIONALE
    const XML_PATH_GESTIONALE_ENABLED = "gestionale/general/enabled";
    const XML_PATH_GESTIONALE_FTP_HOST = "gestionale/general/ftp_host";
    const XML_PATH_GESTIONALE_FTP_USERNAME = "gestionale/general/ftp_username";
    const XML_PATH_GESTIONALE_FTP_PASSWORD = "gestionale/general/ftp_password";
    const XML_PATH_GESTIONALE_FTP_USE_SFTP = "gestionale/general/ftp_use_ftp";
    const XML_PATH_GESTIONALE_FTP_USE_PASSIVE_MODE= "gestionale/general/use_passive_mode";

    // Drop GESTIONALE Stock Import settings
    const XML_PATH_STOCK_LOG_EMAIL = "gestionale/stock/log_email";
    const XML_PATH_STOCK_REMOTE_PATH = "gestionale/stock/remote_path";
    const XML_PATH_STOCK_LOCAL_PATH = "gestionale/stock/local_path";

    // Drop GESTIONALE Orders Export Path
    const XML_PATH_ORDERS_LOCAL_PATH = "gestionale/orders/local_path";
    const XML_PATH_ORDERS_LOCAL_PROCESSED_PATH = "gestionale/orders/local_processed_path";
    const XML_PATH_ORDERS_REMOTE_IMPORT_PATH = "gestionale/orders/remote_import_path";
    const XML_PATH_ORDERS_REMOTE_EXPORT_PATH = "gestionale/orders/remote_export_path";

    // Sender Email
    const XML_PATH_GENERAL_SENDER_EMAIL = 'trans_email/ident_support/email';
    const XML_PATH_GENERAL_SENDER_NAME = 'trans_email/ident_support/name';


    // Offline payment methods
    protected $offlineMethods = ["checkmo", "banktransfer","msp_cashondelivery"];
    protected $cachet = ["checkmo","msp_cashondelivery"];

    /**
     * @param $field
     * @param null $storeId
     * @return mixed
     */
    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    public function isGestionaleEnabled(){
        return $this->getConfigValue( self::XML_PATH_GESTIONALE_ENABLED );
    }

    // FTP settings
    public function getFtpHost(){
        return $this->getConfigValue( self::XML_PATH_GESTIONALE_FTP_HOST);
    }
    public function getFtpUsername(){
        return $this->getConfigValue( self::XML_PATH_GESTIONALE_FTP_USERNAME);
    }
    public function getFtpPassword(){
        return $this->getConfigValue( self::XML_PATH_GESTIONALE_FTP_PASSWORD);
    }
    public function getFtpUsePassiveMove(){
        return $this->getConfigValue( self::XML_PATH_GESTIONALE_FTP_USE_PASSIVE_MODE);
    }
    public function getFtpUseSftp(){
        return $this->getConfigValue( self::XML_PATH_GESTIONALE_FTP_USE_SFTP);
    }

    // Stock import settings
    public function getStockLogEmail(){
        return $this->getConfigValue(self::XML_PATH_STOCK_LOG_EMAIL);
    }
    public function getRemoteFtpStockPath(){
        return $this->getConfigValue(self::XML_PATH_STOCK_REMOTE_PATH);
    }
    public function getLocalStockPath(){
        return $this->getConfigValue(self::XML_PATH_STOCK_LOCAL_PATH);
    }

    // Order export settings
    public function getOrdersLocalPath(){
        return $this->getConfigValue(self::XML_PATH_ORDERS_LOCAL_PATH);
    }
    public function getOrdersLocalProcessedPath(){
        return $this->getConfigValue(self::XML_PATH_ORDERS_LOCAL_PROCESSED_PATH);
    }
    public function getOrdersRemoteImportPath(){
        return $this->getConfigValue(self::XML_PATH_ORDERS_REMOTE_IMPORT_PATH);
    }
    public function getOrdersRemoteExportPath(){
        return $this->getConfigValue(self::XML_PATH_ORDERS_REMOTE_EXPORT_PATH);
    }

    // Sender log email
    public function getGeneralSenderEmail(){
        return $this->getConfigValue(self::XML_PATH_GENERAL_SENDER_EMAIL);
    }
    public function getGeneralSenderName(){
        return $this->getConfigValue(self::XML_PATH_GENERAL_SENDER_NAME);
    }

    /**
     * Return offline payments method
     * @return array
     */
    public function getOfflineMethods(){
        return ["checkmo", "banktransfer","msp_cashondelivery"];
    }

    public function getCachet(){
        return ["checkmo","msp_cashondelivery"];
    }
}