<?php
/**
 * Created by Simone Monterubbiano.
 * Email: s.monterubbiano@drop.it
 * Date: 13/07/2018
 * File name: ShippingImport.php
 * Project: JustEat
 */

namespace Drop\Gestionale\Cron;

class ShippingImport {

    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;
    /**
     * @var \Drop\Gestionale\Model\GestionaleFtp
     */
    private $twsFtp;
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;

    /**
     * ShippingImport constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\Gestionale\Model\GestionaleFtp $twsFtp
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\Gestionale\Model\GestionaleFtp $twsFtp,
        \Drop\Gestionale\Logger\Logger $logger
    ) {
        $this->publisher = $publisher;
        $this->twsFtp = $twsFtp;
        $this->logger = $logger;
    }

    public function execute() {
        $this->logger->info("[SHIPPING-IMPORT] - Cron start",["method"=>__METHOD__]);

        // Check semaphore "TransferOk"
        if(!$this->twsFtp->semaphoreExists("EXPORT")){
            $this->logger->info("[SHIPPING-IMPORT] - Semaphore TransferOk not exists, not create job",["method"=>__METHOD__]);
            return $this;
        }

        // Create job shipping_import
        $this->publisher->publish('shipping_import', "Import shipping from GESTIONALE", "");
        $this->logger->info("[SHIPPING-IMPORT] - Created job shipping_import",["method"=>__METHOD__]);

        return $this;
    }
}