<?php
/*
 * Description: OrderPlaceAfter.php
 * @date: 15-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Observer\Order;

class PlaceAfter implements \Magento\Framework\Event\ObserverInterface {
    

    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;
    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;

    /**
     * PlaceAfter constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\Gestionale\Logger\Logger $logger
    ) {
        $this->logger = $logger;
        $this->publisher = $publisher;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();

        // Order Id
        $orderId = $order->getId();

        // Check if observer incrementId is empty
        $incrementId = $order->getIncrementId();

        // If incrementId is empty, return
        if(empty($incrementId)){
            $this->logger->critical("[GENERATE-XML-FILE] - IncrementId from observer is empty",["method"=>__METHOD__]);
            return $this;
        }

        // Create job
        $this->publisher->publish('checkout_submit_all_after', "#{$incrementId} - Order created - Generate XML", $orderId);
        $this->logger->info("[GENERATE-XML-FILE] - Created job checkout_submit_all_after",["method"=>__METHOD__,"incrementId"=>$incrementId]);

        return $this;
    }
}