<?php

/*
 * Description: Stock.php
 * @date: 17-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Model\Consumer\Stock;

class Import implements \Rcason\Mq\Api\ConsumerInterface {
    
    protected $stock = null;
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;

    /**
     * Import constructor.
     * @param \Drop\Gestionale\Model\Stock $stock
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Drop\Gestionale\Model\Stock $stock,
        \Drop\Gestionale\Logger\Logger $logger
    ){
        $this->stock = $stock;
        $this->logger = $logger;
    }
    
    public function process($message) {
        $this->logger->info("[STOCK] - Consume message job",["method"=>__METHOD__]);
        $this->stock->import();
    }
}