<?php

/*
 * Description: OrderPlaceAfter.php
 * @date: 16-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Model\Consumer\Order;

class CancelAfter implements \Rcason\Mq\Api\ConsumerInterface
{
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;
    /**
     * @var \Drop\Gestionale\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\Sales\Model\OrderRepository
     */
    private $orderRepository;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private $productRepository;
    /**
     * @var \Magento\Framework\Filesystem\Io\File
     */
    private $file;
    /**
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    private $dir;
    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $date;

    /**
     * CancelAfter constructor.
     * @param \Drop\Gestionale\Logger\Logger $logger
     * @param \Drop\Gestionale\Helper\Data $helper
     * @param \Magento\Sales\Model\OrderRepository $orderRepository
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Magento\Framework\Filesystem\Io\File $file
     * @param \Magento\Framework\Filesystem\DirectoryList $dir
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     */
    public function __construct(
        \Drop\Gestionale\Logger\Logger $logger,
        \Drop\Gestionale\Helper\Data $helper,
        \Magento\Sales\Model\OrderRepository $orderRepository,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Framework\Filesystem\Io\File $file,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Framework\Stdlib\DateTime\DateTime $date
    ) {
        $this->logger = $logger;
        $this->helper = $helper;
        $this->orderRepository = $orderRepository;
        $this->productRepository = $productRepository;
        $this->file = $file;
        $this->dir = $dir;
        $this->date = $date;
    }

    public function process($incrementId)
    {
        // If incrementId is empty return
        if (empty( $incrementId )) {
            $this->logger->error("[GENERATE-XML-FILE] - Order incrementId is empty, return",["method"=>__METHOD__]);
            return $this;
        }

        // Load order by incrementId
        $order = $this->modelOrder->loadByIncrementId( $incrementId );

        // If order is not an object, return
        if (!is_object( $order )) {
            $this->logger->error("[GENERATE-XML-FILE] - Order is not an object, return",["method"=>__METHOD__]);
            return $this;
        }

        // File name where saving XML content
        $dateTime = $this->date->date("YmdHis");
        $fileName = "OUT_941_ITA3PL_".$dateTime."_".$order->getIncrementId().".ITA";
        $localFilePath = $this->dir->getRoot() . $this->helper->getOrdersLocalPath() . $fileName;

        // Generate XML
        $xml = $this->helper->generateConfirmOrderXml($order); // 941 file

        // Save order XML to file
        try {
            $this->file->write( $localFilePath, $xml, 0666 );
            $this->logger->info("[GENERATE-XML-FILE] - Order canceled",[
                    "incrementId"=>$order->getIncrementId(),
                    "method"=>__METHOD__]
            );
        }catch (\Exception $e){
            $this->logger->critical("[GENERATE-XML-FILE] - ERROR generating XML order canceled file",[
                    "incrementId"=>$order->getIncrementId(),
                    "method"=>__METHOD__,
                    "exception" => $e->getMessage()]
            );
        }

        return;
    }
}
