<?php

/*
 * Description: Base.php
 * @date: 28-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Model\Consumer;

class Base {
    
    protected $_profileId;
    protected $_offlineMethods = ["checkmo", "banktransfer","msp_cashondelivery"];

    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    protected $logger;
    /**
     * @var \Drop\Gestionale\Helper\Data
     */
    protected $helper;
    /**
     * @var \Magento\Framework\Filesystem\Io\File
     */
    protected $file;
    /**
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    protected $dir;
    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    protected $date;
    /**
     * @var \Magento\Sales\Model\OrderRepository
     */
    protected $orderRepository;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    protected $productRepository;


    /**
     * Base constructor.
     * @param \Drop\Gestionale\Logger\Logger $logger
     * @param \Drop\Gestionale\Helper\Data $helper
     * @param \Magento\Sales\Model\OrderRepository $orderRepository
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Magento\Framework\Filesystem\Io\File $file
     * @param \Magento\Framework\Filesystem\DirectoryList $dir
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     */
    public function __construct(
        \Drop\Gestionale\Logger\Logger $logger,
        \Drop\Gestionale\Helper\Data $helper,

        \Magento\Sales\Model\OrderRepository $orderRepository,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Framework\Filesystem\Io\File $file,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Framework\Stdlib\DateTime\DateTime $date
    ) {
        $this->logger = $logger;
        $this->helper = $helper;
        $this->file = $file;
        $this->dir = $dir;
        $this->date = $date;
        $this->orderRepository = $orderRepository;
        $this->productRepository = $productRepository;
    }
}
