<?php

/*
 * Description: StockImport.php
 * @date: 17-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Cron;

class StockImport
{
    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;
    /**
     * @var \Drop\Gestionale\Model\Consumer\Stock\Import
     */
    private $stock;
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;


    /**
     * StockImport constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\Gestionale\Model\Stock $stock
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\Gestionale\Model\Stock $stock,
        \Drop\Gestionale\Logger\Logger $logger
    ) {

        $this->publisher = $publisher;
        $this->stock = $stock;
        $this->logger = $logger;
    }
    
    public function execute(){
        $this->logger->info("[STOCK] - Cron start",["method"=>__METHOD__]);

        // Check if there are XML files to send via FTP
        if(!count($this->stock->getStockFileContent())){
            $this->logger->info("[STOCK] - No stock file available, not create job",["method"=>__METHOD__]);
            return $this;
        }
        
        // Publish queue message
        $this->publisher->publish('stock_import', "Import stock CSV", "");
        $this->logger->info("[STOCK] - Created job stock_import",["method"=>__METHOD__]);

        return $this;
    }
}