<?php

/*
 * Description: Gestionale.php
 * @date: 14-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Cron;

class SendXml
{
    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;
    /**
     * @var \Drop\Gestionale\Model\Consumer\Ftp\SendXml
     */
    private $modelSendXml;
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;


    /**
     * SendXml constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\Gestionale\Model\Consumer\Ftp\SendXml $modelSendXml
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\Gestionale\Model\Consumer\Ftp\SendXml $modelSendXml,
        \Drop\Gestionale\Logger\Logger $logger
    ) {

        $this->publisher = $publisher;
        $this->modelSendXml = $modelSendXml;
        $this->logger = $logger;
    }
    
    public function execute(){

        // Check if there are XML files to send via FTP
        if(!count($this->modelSendXml->getFilesToSend())){
            $this->logger->info("[SEND-XML] - No XML files to send via FTP, not create job",["method"=>__METHOD__]);
            return $this;
        }

        // Create job ftp_send_xml
        $this->publisher->publish('ftp_send_xml', "Send XML files via FTP", "");
        $this->logger->info("[SEND-XML] - Created job ftp_send_xml",["method"=>__METHOD__]);

        return $this;
    }
}