<?php

/*
 * Description: OrderPlaceAfter.php
 * @date: 15-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */

namespace Drop\Gestionale\Observer\Order;

class InvoiceRegister implements \Magento\Framework\Event\ObserverInterface {
    /**
     * @var \Rcason\Mq\Api\PublisherInterface
     */
    private $publisher;
    /**
     * @var \Drop\Gestionale\Logger\Logger
     */
    private $logger;

    /**
     * InvoiceRegister constructor.
     * @param \Rcason\Mq\Api\PublisherInterface $publisher
     * @param \Drop\Gestionale\Logger\Logger $logger
     */
    public function __construct(
        \Rcason\Mq\Api\PublisherInterface $publisher,
        \Drop\Gestionale\Logger\Logger $logger
    ) {
        $this->publisher = $publisher;
        $this->logger = $logger;
    }
    
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        // Check if observer incrementId is empty
        $incrementId = $incrementId = $observer->getEvent()->getOrder()->getIncrementId();

        // If incrementId is empty, return
        if(empty($incrementId)){
            $this->logger->critical("[GENERATE-XML-FILE] - IncrementId from observer is empty",["method"=>__METHOD__]);
            return $this;
        }

        $this->publisher->publish('order_invoice_register', "#{$incrementId} - Invoice created - Generate XML", $observer->getOrder()->getId());
        $this->logger->info("[GENERATE-XML-FILE] - Created job order_invoice_register",["method"=>__METHOD__,"incrementId"=>$incrementId]);
        return $this;
    }
}