<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace Drop\Import\Helper\System;

class Stock extends \Drop\Import\Helper\Data implements SystemInterface {
    
    /**
     * TODO: Rendere campi come Product altrimenti non soddisfa l'interface e non funziona
     */
    
    const XML_PATH_STOCK_TYPE = 'dropimport/stock/type';
    const XML_PATH_STOCK_PATH = 'dropimport/stock/local_file_path';
    const XML_PATH_STOCK_PATH_PROCESSED = 'dropimport/stock/local_file_processed_path';
    const XML_PATH_STOCK_LOG_EMAIL = 'dropimport/stock/log_email';
    const XML_PATH_GENERAL_SENDER_EMAIL = 'trans_email/ident_support/email';
    const XML_PATH_GENERAL_SENDER_NAME = 'trans_email/ident_support/name';
    
    const ENTITY_CODE = 'catalog_stock'; //Da creare
    
    public function getStockType(){
        return $this->getScopeConfig(self::XML_PATH_STOCK_TYPE);
    }
    
    public function getStockLocalFilePath(){
        return $this->getScopeConfig(self::XML_PATH_STOCK_PATH);
    }
    
    public function getStockLocalFileProcessedPath(){
        return $this->getScopeConfig(self::XML_PATH_STOCK_PATH_PROCESSED);
    }
    
    public function getStockLogEmail(){
        return $this->getScopeConfig(self::XML_PATH_STOCK_LOG_EMAIL);
    }
    
    public function getGeneralSenderEmail(){
        return $this->getScopeConfig(self::XML_PATH_GENERAL_SENDER_EMAIL);
    }
    
    public function getGeneralSenderName(){
        return $this->getScopeConfig(self::XML_PATH_GENERAL_SENDER_NAME);
    }
    
    //Da utilizzare, messi solo perchè altrimenti da errore
    /**
     * Get Behavior
     * 
     * @return string
     */
    public function getBehavior()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_BEHAVIOR);
    }

    /**
     * Get Validation Strategy
     * 
     * @return string
     */
    public function getValidationStrategy()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_VALIDATION_STRATEGY);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getAllowedErrorCount()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_ALLOWED_ERROR_COUNT);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getImportMethod()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_IMPORT_METHOD);
    }

    /**
     * Get Allowed Error Count
     * 
     * @return int
     */
    public function getImportPathUrl()
    {
        return $this->getScopeConfig(self::XML_PATH_STOCK_IMPORT_PATH_URL);
    }

    /**
     * Get Ignore Duplicates
     * 
     * @return bool
     */
    public function getIgnoreDuplicates()
    {
        return (bool) $this->getScopeConfig(self::XML_PATH_STOCK_IGNORE_DUPLICATES);
    }    

    /**
     * Get Entity Code
     * 
     * @return bool
     */
    public function getEntityCode()
    {
        return self::ENTITY_CODE;
    }        
       
}