<?php
/**
 * Created by Simone Monterubbiano.
 * Email: s.monterubbiano@drop.it
 * Date: 30/07/2018
 * File name: ImportCustomer.php
 * Project: JustEat
 */

namespace Drop\Gestionale\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ImportCustomer extends Command
{
    /**
     * @var \Magento\Framework\File\Csv
     */
    private $csv;
    /**
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    private $dir;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    private $customerFactory;

    /**
     * ImportCustomer constructor.
     * @param \Magento\Framework\File\Csv $csv
     * @param \Magento\Framework\Filesystem\DirectoryList $dir
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Customer\Model\CustomerFactory $customerFactory
     */
    public function __construct(
        \Magento\Framework\File\Csv $csv,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Model\CustomerFactory $customerFactory
    )
    {
        parent::__construct();
        $this->csv = $csv;
        $this->dir = $dir;
        $this->storeManager = $storeManager;
        $this->customerFactory = $customerFactory;
    }

    protected function configure()
    {
        $this->setName('drop:gestionale:importcustomers');
        $this->setDescription('Import Customers');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('This is a normal message.');
        $output->writeln("<info>This is an info message.</info>");
        $output->writeln("<comment>This is a comment.</comment>");
        $output->writeln("<error>This is an error message.</error>");

        // Read CSV
        $rows = $this->readCsv();

        foreach($rows as $customer):
            $this->createCustomer($customer);
        endforeach;
    }

    private function readCsv(){
        // Read CSV
        $path = $this->dir->getRoot()."/pub/customers.csv";
        $data = $this->csv->getData($path);
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        die(__METHOD__);
        return $array;
    }

    private function createCustomer($customerData){
        // Get Website ID
        $websiteId  = $this->storeManager->getWebsite()->getWebsiteId();

        // Instantiate object (this is the most important part)
        $customer = $this->customerFactory->create();
        $customer->setWebsiteId($websiteId);

        // Preparing data for new customer
        $customer->setEmail($customerData["email"]);
        $customer->setFirstname($customerData["firstname"]);
        $customer->setLastname($customerData["lastname"]);
        $customer->setPassword($customerData["password"]);

        // Save data
        $customer->save();

        // Send email
        $customer->sendNewAccountEmail();
    }
}