# Magento 2 Geolocation module
Geolocalize customer based on Geoip (MaxMind) and browser language. Fully compatible with Varnish (Js redirect)! 

## Installation
- Add the VCS repository to composer:
```sh
$ composer config repositories.drop.fe vcs git@bitbucket.org:dropsrl/drop-module-geolocation.git
```

- Add the module to composer:
```sh
$ composer require drop/module-geolocation
```

- Enable module, install and clear magento cache
```sh
$ bin/magento module:enable Drop_Geolocation
$ bin/magento module:enable setup:upgrade
$ bin/magento module:enable cache:clear
```

## Description
- Redirect user to correct store code based by country (IP) and browser language
- Redirect user to requested page in the correct store code
- A fallback page is showed to customer if geolocation fails
- Show only customer address based on current country id (prevent orders to be shipped to a different country)
- Show a popup to change store if customer ask to change country on checkout, shipping address or customer address edit
- Customer can always change country/locale with a popup link in header and footer
- User Agent bots exclusion
- Update quote address country id based on current geolocation country

## Requirements
- PHP >= 7.0.0
- Mage_Core
- tobai/magento2-geo-ip2

## Compatibility
- Magento >= 2.2
- Not tested on 2.1 and 2.0

## Support
If you encounter any problems or bugs, please contact us [here](https://www.drop.it) or create an issue.

## Developer
Cristiano Pieroni (c.pieroni@drop.it)

## Licence
TODO

## Copyright
TODO

## TODO
- Connect with translation CMS Pages
- Get it work with multistore
- Section to exclude page and ips from geolocation
- Section to block traffic to target ips/user agent
- Test PHP redirect with Varnish disabled (exclude js) 
- If template is cachable=False use PHP Redirect instead of js (Varnish is not working)
- Always use default magento language switcher template
