<?php
/**
 * FrontSendResponseBefore
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Observer;

/**
 * Class FrontSendResponseBefore
 *
 * @package Drop\Geolocation\Observer
 */
class FrontSendResponseBefore implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * @var \Drop\Geolocation\Helper\Bots
     */
    protected $helperBots;
    /**
     * @var \Drop\Geolocation\Helper\Bots
     */
    protected $session;
    /**
     * @var \Drop\Geolocation\Model\Apply
     */
    protected $apply;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlInterface;
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    private $request;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\Framework\App\ActionFlag
     */
    private $actionFlag;
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    protected $_responseFactory;

    /**
     * FrontSendResponseBefore constructor
     *
     * @param \Drop\Geolocation\Helper\Bots $helperBots
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Drop\Geolocation\Model\Session $session
     * @param \Drop\Geolocation\Model\Apply $apply
     * @param \Magento\Framework\UrlInterface $urlInterface
     * @param \Magento\Framework\App\Response\RedirectInterface $redirect
     * @param \Magento\Framework\App\Request\Http $request
     */
    public function __construct(
        \Drop\Geolocation\Helper\Bots $helperBots,
        \Drop\Geolocation\Helper\Data $helper,
        \Drop\Geolocation\Model\Session $session,
        \Drop\Geolocation\Model\Apply $apply,
        \Magento\Framework\UrlInterface $urlInterface,
        \Magento\Framework\App\Request\Http $request,
        \Magento\Framework\App\ActionFlag $actionFlag,
        \Magento\Framework\App\ResponseFactory $responseFactory
    ) {
        $this->helperBots = $helperBots;
        $this->helper = $helper;
        $this->session = $session;
        $this->apply = $apply;
        $this->urlInterface = $urlInterface;
        $this->request = $request;
        $this->actionFlag = $actionFlag;
        $this->responseFactory = $responseFactory;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return FrontSendResponseBefore
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \MaxMind\Db\Reader\InvalidDatabaseException
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $currentUrl = $this->urlInterface->getCurrentUrl();

        if ($this->request->isAjax()
            || $this->helperBots->isBot()
            || $this->helper->getIsExcludedFromGeolocation($currentUrl)
            || ($this->helper->getVarnishIsActive()) // && !$this->apply->getStoreCodeIsOnUrl($currentUrl)
            //if Varnish is active and store is not in url, let it pass to redirect in Javascript to prevent redirect caching problems
        ) {
            return $this;
        }

        $countryId = $this->session->getCountryId();
        if(empty($countryId)) {
            $this->session->setGeolocatedCountryId();
            $countryId = $this->session->getCountryId();
        }

        $locale = $this->session->getLocale();
        if(empty($locale)) {
            $this->session->setBrowserLocale();
            $locale = $this->session->getLocale();
        }

        $rightPath = $this->apply->getUrlToRightStoreView($countryId, $locale, $currentUrl);
        if(!empty($rightPath)) {
            $this->responseFactory->create()
                ->setRedirect($rightPath)
                ->sendResponse();
            exit();
        }

        return $this;
    }

}
