<?php
/**
 * ShipTo
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Store\Model\ScopeInterface;

class DifferentCountry extends Action
{

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Drop\Geolocation\Model\Session
     */
    protected $session;

    /**
     * @var \Drop\Geolocation\Model\Apply
     */
    protected $apply;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;
    /**
     * @var \Drop\Geolocation\Helper\Apply
     */
    private $applyHelper;
    /**
     * @var \Drop\Geolocation\Helper\Bots
     */
    private $helperBots;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlInterface;
    /**
     * @var \Magento\Framework\App\Response\RedirectInterface
     */
    private $redirect;
    /**
     * @var \Magento\Framework\Controller\Result\Json
     */
    protected $resultJson;

    /**
     * ShipTo constructor
     *
     * @param Context $context
     * @param \Drop\Geolocation\Model\Session $session
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Drop\Geolocation\Model\Apply $apply
     * @param \Drop\Geolocation\Helper\Bots $helperBots
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Drop\Geolocation\Helper\Apply $applyHelper
     * @param \Magento\Framework\UrlInterface $urlInterface
     * @param \Magento\Framework\App\Response\RedirectInterface $redirect
     * @param \Magento\Framework\Controller\Result\Json $resultJson
     */
    public function __construct(
        Context $context,
        \Drop\Geolocation\Model\Session $session,
        \Drop\Geolocation\Model\Apply $apply,
        \Drop\Geolocation\Helper\Bots $helperBots,
        \Drop\Geolocation\Helper\Data $helper,
        \Drop\Geolocation\Helper\Apply $applyHelper,
        \Magento\Framework\UrlInterface $urlInterface,
        \Magento\Framework\App\Response\RedirectInterface $redirect,
        \Magento\Framework\Controller\Result\Json $resultJson
    )
    {
        parent::__construct($context);

        $this->request = $context->getRequest();
        $this->session = $session;
        $this->apply = $apply;
        $this->helperBots = $helperBots;
        $this->helper = $helper;
        $this->applyHelper = $applyHelper;
        $this->urlInterface = $urlInterface;
        $this->redirect = $redirect;
        $this->resultJson = $resultJson;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Json $resultJson */
        $resultJson = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON);
        $refererUrl = $this->redirect->getRefererUrl();

        if (!$this->request->isAjax()
            || $this->helperBots->isBot()
            || $this->helper->getIsExcludedFromGeolocation($refererUrl)
            || ($this->session->getUserIsManuallyGeolocated() && $this->applyHelper->getStoreCodeIsOnUrl($refererUrl))
        ) {
            $resultJson->setData(false);
            return $resultJson;
        }

        //Always get from geolocation
        $countryId = $this->session->getGeolocatedCountryId();
        $locale = $this->session->getBrowserLocale();
        
        if(!$this->applyHelper->getStoreCodeIsOnUrl($refererUrl)) {
            //Caso particolare: entro, sono IT ma vado in PT. Torno in home levando lo store code dall'url a mano.
            //Quando calcolo il different Country basandomi sulla Geoip mi torna che sono IT e rimane in home quando invece stavo navigando in PT.
            if(!empty($this->session->getCountryId())) {
                $countryId = $this->session->getCountryId();
            }
            if(!empty($this->session->getLocale())) {
                $locale = $this->session->getLocale();
            }
        }

        $rightPath = $this->apply->getUrlToRightStoreView($countryId, $locale, $refererUrl);
        $resultJson->setData($rightPath);
        return $resultJson;
    }

}
