define([
    'jquery',
    'Magento_Ui/js/form/element/select',
    'Magento_Ui/js/modal/modal',
    'mage/url'
], function ($, Select, Modal, Url) {
    'use strict';

    return Select.extend({
        initialValue: null,
        changeCountryTemplate: '#change-country-alert',

        initialize: function() {
            var self = this;
            $(this.changeCountryTemplate).modal({
                title: 'Do you want change country?',
                type: 'popup',
                responsive: true,
                innerScroll: false,
                modalClass: 'change-country-modal',
                buttons: [
                    {
                        text: 'Change country',
                        class: 'action-primary action-accept',
                        click: function () {
                            // document.location = Url.build('geolocation/index/apply') + '?country_id=' + self.value();
                            document.location = '/geolocation/index/apply' + '?country_id=' + self.value();
                        }
                    },
                    {
                        text: 'Cancel',
                        class: 'action-secondary action-dismiss',
                        click: function () {
                            this.closeModal();
                        }
                    }
                ],
	            closed: function (){
		            self.value(self.initialValue);
	            }
            });

            return this._super();
        },

        setInitialValue: function () {
            this.initialValue = this.getInitialValue();
            this._super();
            return this;
        },

        onUpdate: function (currentValue) {
            if(currentValue != this.initialValue) {
                $('.change-country-modal .modal-title').text('Do you want change country in ' + this.indexedOptions[currentValue].label);
                $(this.changeCountryTemplate).modal('openModal');
            }
            return this._super();
        },

        setDifferedFromDefault: function () {
            this.isDifferedFromDefault(false);
        }

    });
});
